/*
** EXAMP027.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iLoop, iNumLocks;
DBFIELD pFieldInfo;
DBFILELOCKS *pLocks;
char *aTypes[] = { "DBRECORDLOCK", "DBHEADERLOCK", "", "DBFILELOCK" };

DBFIELD aFields[] = { { "CHARACTER", 'C', 10, 0 },
                      { "DATE",      'D',  8, 0 },
                      { "FLOAT",     'F',  5, 2 },
                      { "LOGICAL",   'L',  1, 0 },
                      { "MEMO",      'M', 10, 0 },
                      { "NUMERIC",   'N',  5, 2 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 6, aFields, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4|DBOPENLAN );
   DBLockFile( iDBF );
   for( iLoop = 0; iLoop < 6; iLoop++ )
   {
      DBGetFieldDescription( iDBF, iLoop, &pFieldInfo );
      printf( "%10s %c %2d %2d\n", pFieldInfo.name, pFieldInfo.type,
                               pFieldInfo.len, pFieldInfo.decpl );
   }
   DBGetLockInfo( iDBF, &pLocks, &iNumLocks );
   printf( "\n%d %s applied", iNumLocks, aTypes[ pLocks[0].type-1 ] );
   DBUnLockAll( iDBF );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
