/*
** L1DEM019.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

struct { char   cStatus;
         double dEmpIDNumber;
         char   szEmpName[26];
         double dEmpAge;
         char   szEmpShift[5];
         char   cInsured;
       } pEmpRec;

int iDBF, iCDX, iLoop, iStatus;
long lTag1, lTag2, lTag3, lTag4, lTag5, lRecNo;
char szKey[26], *pKey;
double dEmpIDNumbers[5] = { 12, 25 };
char *pEmpNames[] = { "Marc Leger", "Bill Thomas" };
double dEmpAges[5] = { 25, 34 };
char *pEmpShifts[] = { "FULL", "PART" };
char pInsured[2] = { 'T', 'F' };

DBFIELD Fields[] = { { "EMPIDNO",  'N',  2, 0 },
                     { "EMPNAME",  'C', 25, 0 },
                     { "EMPAGE",   'N',  2, 0 },
                     { "EMPSHIFT", 'C',  4, 0 },
                     { "INSURED",  'L',  1, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 5, Fields, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBOPENSTANDARD|DBFOXPRO2 );

   DBCreateTag( iCDX, "EMPIDNO", DBNUMERICKEY|DBUNIQUEINDEX, "EMPIDNO", 8, 0, NULL );
   DBCreateTag( iCDX, "EMPNAME", DBCHARACTERKEY, "EMPNAME", 25, 0, NULL );
   DBCreateTag( iCDX, "EMPAGE", DBNUMERICKEY, "EMPAGE", 8, 0, NULL );
   DBCreateTag( iCDX, "EMPSHIFT", DBCHARACTERKEY, "EMPSHIFT", 4, 0, NULL );

   DBOpenNamedTag( &lTag1, iCDX, "EMPIDNO" );
   DBSetDefaultKeyType( lTag1, DBNUMERICKEY );

   DBOpenNamedTag( &lTag2, iCDX, "EMPNAME" );
   DBSetDefaultKeyType( lTag2, DBCHARACTERKEY );

   DBOpenNamedTag( &lTag3, iCDX, "EMPAGE" );
   DBSetDefaultKeyType( lTag3, DBNUMERICKEY );

   DBOpenNamedTag( &lTag4, iCDX, "EMPSHIFT" );
   DBSetDefaultKeyType( lTag4, DBCHARACTERKEY );

   for( iLoop = 0; iLoop < 2; iLoop++ )
   {
      pEmpRec.dEmpIDNumber = dEmpIDNumbers[ iLoop ];
      strcpy( pEmpRec.szEmpName, pEmpNames[ iLoop ] );
      pEmpRec.dEmpAge = dEmpAges[ iLoop ];
      strcpy( pEmpRec.szEmpShift, pEmpShifts[ iLoop ] );
      pEmpRec.cInsured = pInsured[ iLoop ];

      DBPutRecordFromBuffer( iDBF, ( char* )&pEmpRec, &lRecNo, DBAPPENDRECORD );

      DBNumericToKey( lTag1, szKey, pEmpRec.dEmpIDNumber );
      DBInsertKey( lTag1, szKey, lRecNo );

      DBInsertKey( lTag2, pEmpRec.szEmpName, lRecNo );

      DBNumericToKey( lTag3, szKey, pEmpRec.dEmpAge );
      DBInsertKey( lTag3, szKey, lRecNo );

      DBInsertKey( lTag4, pEmpRec.szEmpShift, lRecNo );
   }

   printf( "\nEmployees by ID number..\n" );

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( iStatus == DBSUCCESS )
   {
      DBGetRecordToBuffer( iDBF, ( char* )&pEmpRec, lRecNo );

      printf( "\nEmployee ID Number: %2.0f\n", pEmpRec.dEmpIDNumber );
      printf( "Employee Name     : %s\n", pEmpRec.szEmpName );
      printf( "Employee Age      : %2.0f\n", pEmpRec.dEmpAge );
      printf( "Employee Shift    : %s\n", pEmpRec.szEmpShift );
      printf( "Employee Insured  : %s\n", pEmpRec.cInsured ? "Y":"N" );

      iStatus = DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   printf( "\nEmployees by name..\n" );
   iStatus = DBSUCCESS;

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while( iStatus == DBSUCCESS )
   {
      DBGetRecordToBuffer( iDBF, ( char* )&pEmpRec, lRecNo );

      printf( "\nEmployee ID Number: %2.0f\n", pEmpRec.dEmpIDNumber );
      printf( "Employee Name     : %s\n", pEmpRec.szEmpName );
      printf( "Employee Age      : %2.0f\n", pEmpRec.dEmpAge );
      printf( "Employee Shift    : %s\n", pEmpRec.szEmpShift );
      printf( "Employee Insured  : %s\n", pEmpRec.cInsured ? "Y":"N" );

      iStatus = DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   printf( "\nEmployees by age..\n" );
   iStatus = DBSUCCESS;

   DBGoFirstKey( lTag3, szKey, &lRecNo );

   while( iStatus == DBSUCCESS )
   {
      DBGetRecordToBuffer( iDBF, ( char* )&pEmpRec, lRecNo );

      printf( "\nEmployee ID Number: %2.0f\n", pEmpRec.dEmpIDNumber );
      printf( "Employee Name     : %s\n", pEmpRec.szEmpName );
      printf( "Employee Age      : %2.0f\n", pEmpRec.dEmpAge );
      printf( "Employee Shift    : %s\n", pEmpRec.szEmpShift );
      printf( "Employee Insured  : %s\n", pEmpRec.cInsured ? "Y":"N" );

      iStatus = DBGoNextKey( lTag3, szKey, &lRecNo );
   }

   printf( "\nEmployees by shift..\n" );
   iStatus = DBSUCCESS;

   DBGoFirstKey( lTag4, szKey, &lRecNo );

   while( iStatus == DBSUCCESS )
   {
      DBGetRecordToBuffer( iDBF, ( char* )&pEmpRec, lRecNo );

      printf( "\nEmployee ID Number: %2.0f\n", pEmpRec.dEmpIDNumber );
      printf( "Employee Name     : %s\n", pEmpRec.szEmpName );
      printf( "Employee Age      : %2.0f\n", pEmpRec.dEmpAge );
      printf( "Employee Shift    : %s\n", pEmpRec.szEmpShift );
      printf( "Employee Insured  : %s\n", pEmpRec.cInsured ? "Y":"N" );

      iStatus = DBGoNextKey( lTag4, szKey, &lRecNo );
   }

   DBCloseIndex( iCDX );
   DBCloseFile( iDBF );
   DBTerminate();
}
