/*
** D4DEMO5.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int  iDBF, iMDX, iLoop;
long lRecNo, lTag1, lTag2;
char *pFName[] = { "Marc", "Robert", "Ashley", "Amelia", "Shellye" };
char *pLName[] = { "Leger", "Schoolcraft", "Thomas", "Davis", "Brooks" };
char szKey[26], szFName[26], szLName[26];

DBFIELD Fields[] = { { "FNAME", 'C', 25, 0 },
                     { "LNAME", 'C', 25, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4|DBOPENLAN );

   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBOPENLAN|DBDBASE4 );

   DBCreateTag( iMDX, "FNAME", DBCHARACTERKEY, "FNAME", 25, 0, NULL );
   DBCreateTag( iMDX, "LNAME", DBCHARACTERKEY, "LNAME", 25, 0, NULL );

   DBOpenNamedTag( &lTag1, iMDX, "FNAME" );
   DBOpenNamedTag( &lTag2, iMDX, "LNAME" );

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      DBPutNamedData( iDBF, "FNAME", pFName[ iLoop ] );
      DBPutNamedData( iDBF, "LNAME", pLName[ iLoop ] );
      DBLockHeader( iDBF );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
      DBLockIndex( iMDX );
      DBInsertKey( lTag1, pFName[ iLoop ], lRecNo );
      DBInsertKey( lTag2, pLName[ iLoop ], lRecNo );
      DBUnLockIndex( iMDX );
      DBUnLockAll( iDBF );
   }

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "%s %ld\n", szKey, lRecNo );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while (DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "%s %ld\n", szKey, lRecNo );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   strcpy( szKey, "Schoolcraft" );
   DBKeySearch( lTag2, szKey, &lRecNo, DBKEYEQUAL );

   DBLockRecord( iDBF, lRecNo );
   DBPutFieldData( iDBF, 0, "Kerry" );
   DBPutFieldData( iDBF, 1, "Adams" );
   DBPutRecord( iDBF, &lRecNo, DBUPDATERECORD );

   strcpy( szKey, "Robert" );
   DBLockIndex( iMDX );
   DBDeleteKey( lTag1, szKey, lRecNo );
   strcpy( szKey, "Schoolcraft" );
   DBDeleteKey( lTag2, szKey, lRecNo );

   DBInsertKey( lTag1, "Kerry", lRecNo );
   DBInsertKey( lTag2, "Adams", lRecNo );
   DBUnLockIndex( iMDX );
   DBUnLockAll( iDBF );

   puts( "" );

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "%s %ld\n", szKey, lRecNo );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while (DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "%s %ld\n", szKey, lRecNo );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
}

