/*
** L1DEM007.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

void BuildDatabase ( void );
void Index         ( void );
void FindKey       ( void );

DBFIELD Field[] = { { "LENGTH", 'N', 11, 0 } };

int iDBF, iNDX;
double iLoop, dKey;
long lRecNo, lTimeDiff, lNDX;
char szStartTime[10], szEndTime[10], szKey[20];

void main( void )
{
   DBInitialize( 20, 0 );
   BuildDatabase();
   Index();
   FindKey();
   DBCloseIndex( iNDX );
   DBCloseFile( iDBF );
   DBTerminate();
}

void BuildDatabase (void)
{
   DBCreateFile( "EXAMPLE.DBF", 1, Field, DBDBASE3 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE3 );

   DBGetTimeStr( szStartTime, DBHHMMSS );
   printf( "\nStart Time: %s\n\n", szStartTime );
   printf( "Adding 2,000 records...\n\n" );

   for( iLoop=1L; iLoop <=2000L; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, &iLoop );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   };

   DBGetTimeStr( szEndTime, DBHHMMSS );
   printf( "End Time:   %s\n\n", szEndTime );

   DBSecondsBetweenStr( &lTimeDiff, szEndTime, DBHHMMSS, szStartTime, DBHHMMSS);
   printf( "Time difference: %ld seconds.\n\n", lTimeDiff );
}

void Index (void)
{
   DBGetTimeStr( szStartTime, DBHHMMSS );
   printf( "Reindex start time: %s\n", szStartTime );

   DBCreateIndex( "EXAMPLE.NDX", 1, DBDBASE3 );
   DBOpenIndex( &iNDX, "EXAMPLE.NDX", DBDBASE3 );

   DBBuildTag( iDBF, iNDX, "EXAMPLE", DBNUMERICKEY, "LENGTH", 8, 0, NULL, NULL, 0 );

   DBGetTimeStr( szEndTime, DBHHMMSS );
   printf( "Reindex end time:   %s\n", szEndTime );

   DBSecondsBetweenStr( &lTimeDiff, szEndTime, DBHHMMSS, szStartTime, DBHHMMSS );
   printf( "Reindex time difference: %ld seconds.\n\n", lTimeDiff );

   DBOpenTag( &lNDX, iNDX, 0 );
}

void FindKey (void)
{
   DBGoFirstKey( lNDX, szKey, &lRecNo );

   DBKeyToNumeric( lNDX, &dKey, szKey );
   printf( "First key: %5.0f\n", dKey );

   DBGoLastKey( lNDX, szKey, &lRecNo );

   DBKeyToNumeric( lNDX, &dKey, szKey );
   printf( "Last key:  %5.0f\n", dKey );
}
