/*
** L1DEM003.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

DBFIELD Fields[] = { { "FNAME", 'C', 20, 0 },
                     { "LNAME", 'C', 20, 0 },
                     { "PHONE", 'C', 12, 0 } };

int iDBF, iLoop, iName, iPhone;
long lRecNo, lName, lPhone;
char szKey[21], szFName[21], szLName[21], szPhone[13];
char *pFNames[] = { "Marc", "Billy", "Tom", "Lucy", "Ruby" };
char *pLNames[] = { "Leger", "McDaniel", "Adams", "Adams", "Crawford" };
char *pPhone[]  = { "214-555-1212", "214-555-1313", "214-555-1122",
                    "214-555-1234", "214-555-1934" };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 3, Fields, DBCLIPPER5 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBCLIPPER5 );

   DBCreateIndex( "NAME.NTX", 1, DBCLIPPER5 );
   DBOpenIndex( &iName, "NAME.NTX", DBCLIPPER5 );
   DBCreateTag( iName, "NAME", DBCHARACTERKEY, "LNAME", 20, 0, NULL );
   DBOpenTag( &lName, iName, 0);

   DBCreateIndex( "PHONE.NTX", 1, DBCLIPPER5 );
   DBOpenIndex( &iPhone, "PHONE.NTX", DBCLIPPER5 );
   DBCreateTag( iPhone, "PHONE", DBCHARACTERKEY, "PHONE", 12, 0, NULL );
   DBOpenTag( &lPhone, iPhone, 0);

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, pFNames[ iLoop ] );
      DBPutFieldData( iDBF, 1, pLNames[ iLoop ] );
      DBPutFieldData( iDBF, 2, pPhone[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBInsertKey( lName, pLNames[ iLoop ], lRecNo );
      DBInsertKey( lPhone, pPhone[ iLoop ], lRecNo );
   }

   DBGoFirstKey( lName, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "Key stored: %ld %s\n", lRecNo, szKey );
      DBGoNextKey( lName, szKey, &lRecNo );
   }

   printf( "\n" );

   DBGoFirstKey( lPhone, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "Key stored: %s\n", szKey );
      DBGoNextKey( lPhone, szKey, &lRecNo );
   }

   strcpy( szKey, "214-555-1234" );
   DBKeySearch( lPhone, szKey, &lRecNo, DBKEYEQUAL );

   DBGetRecord( iDBF, lRecNo );
   DBGetNamedData( iDBF, "LNAME", szLName );

   strcpy( szKey, szLName );
   DBKeySearch( lName, szKey, &lRecNo, DBEXACT );

   DBGetNamedData( iDBF, "FNAME", szFName );
   DBGetNamedData( iDBF, "LNAME", szLName );
   DBGetNamedData( iDBF, "PHONE", szPhone );

   printf( "\nRecord found: %s %s %s\n\n", szFName, szLName, szPhone );

   DBDeleteKey( lName, szLName, lRecNo );

   DBPutNamedData( iDBF, "LNAME", "Stevens" );
   DBPutRecord( iDBF, &lRecNo, DBUPDATERECORD );

   DBInsertKey( lName, "Stevens", lRecNo );

   DBGoFirstKey( lName, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "Key stored: %ld %s\n", lRecNo, szKey );
      DBGoNextKey( lName, szKey, &lRecNo );
   }

   DBCloseIndex( iName );
   DBCloseIndex( iPhone );
   DBCloseFile( iDBF );
   DBTerminate();
}
