;   EAW2 Door Control file
;--------------------------------
; The semi-colons are comment markers.  Remove them to activate option.
;
;Sysopfirst  Specifies the first name of the sysop as it will be shown to
;            the users.
;
;SysopLast   Specifies the last name of the sysop as it will be shown to
;            the users.
;
;BBSName     Specifies the name of the bbs as it will be shown to users.
;
;Mono        Will disable color on the local side. (Necessary if you are
;            running a monochrome system)
;
;BBSType     Specifies the type of bbs software under which this door program
;            will be run. Valid bbs types include:
;
;                  DOORSYS - The DOOR.SYS format (Wildcat! 3.xx, TAG, etc)
;                     RBBS - Rbbs version 16.1+  (uses DORINFOx.DEF*)
;                    QUICK - Quickbbs,Force,R.A. (uses DORINFOx.DEF**)
;                    PCB12 - Pcboard version 12 (note: see COMPORT note below)
;                    PCB14 - Pcboard version 14
;                    PCB15 - Pcboard version 15
;                  PHOENIX - Phoenix bbs
;                 SPITFIRE - Spitfires drop file (SFDOORS.DAT)
;                     WWIV - WWIV bbs (uses chain.txt)
;                 CALLINFO - Wildcat 2.xx
;
;  Notes    *  ANSI graphics is selected when a "2" is passed in the graphics
;              parameter of the DORINFOx.DEF.   RBBS standard.
;          **  ANSI graphics is selected when a "1" is passed in the graphics
;              parameter of the DORINFOx.DEF.   QuickBBS,Remote Access,FORCE,
;              UltraBBS and many shareware BBSes require this type.
;
;ComPort     For bbs types that do not have the com-port contained in their
;            door information files (such as PCBOARD-12), you will have to
;            specify the com-port. Simply put the port number (i.e. 1,2,etc)
;            not the whole word COM1.
;
;Fossil      Selecting this option will cause EAW2game to use a fossil port
;            driver.  Otherwise EAW2game will use its own internal comport
;            handlers.
;
;Xfossil     Selecting this option will cause EAW2game to use the extended
;            X00 fossil driver.  This will support speeds of 57,000 or higher
;            baud.  Otherwise RAW2game will use its own internal comport
;            handlers.
;
;LockBaud    This will specify a locked baud rate. If you specify this
;            parameter, then no matter what the bbs software says, this baud
;            rate will be used.  Values up to 115200 are allowed.
;            [NOTE: You can also specify the locked baud rate using /Bxxxx
;            from the command line]
;
;Port1       If you must use a non-standard interrupt, EAW2game can be
;Port2       configured for IRQs 0-15. The port# indicates the chosen comport
;Port3       Follow this with the port address in hex.  Afterward put the IRQ
;Port4       in decimal.  For an example if comport 3 at irq 15 and address
;            $03E8 was needed use the following:
;            PORT3 03E8 15
;
;
;Maxtime     The maxtime parameter will allow you to specify a maximum time
;            per session that a user may be in the door. (i.e. if you
;            specified 30 minutes, then if the user had 60 mins left, he could
;            only play for 30 mins)
;
;Status      Specify "ON" if you wish the status line to appear at the bottom
;            of "OFF" if you wish it to be disabled.
;
;Statfore    Statfore foreground color of the status line and the major input
;            fields. (default 7 - lightgrey)
;
;Statback    The background color of the status line (default 1 - blue)
;
;
;------------------------------ Sample Data ----------------------------------
;
SYSOPFIRST DAVID 
SYSOPLAST HEATH
BBSNAME THE DAVASOFT BBS
;
;       ::::------- Put your bbs type here! Select from those listed above
;       ::::
;       \/\/
BBSTYPE PCB15
;
;                   If you are using a bbs type that doesn't provide the com
;        ::-------- port num in it's door information file (such as pcb-12),
;        \/         then uncomment this line and put your com port here.
;COMPORT 1
;
; Uncomment the next line if you use a fossil device driver.
FOSSIL
;
; Uncomment the next line if you use a X00153+ fossil device driver.
;XFOSSIL
;
;           ::------If you are locking ports uncomment this line and set this
;           ::      number to the port speed.
;           \/
LOCKBAUD 38400
;
;       ::------------ If you are going to use a non-standard IRQ place the
;       ::             port address in hex one space after the PORT# option.
;       ::
;       ::  ::-------- If you have a non-standard IRQ position the IRQ number
;       \/  \/         one space after the ports' hex address.
;PORT1 03F8 4
;PORT2 02F8 3
;PORT3 300  10
;PORT4 02E8 3
;
;------------------------------ End of File ----------------------------------

