unit Arrow;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TArrowForm = class(TForm)
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ArrowForm: TArrowForm;

  {These Variables set the init point for the arrow}
  ArrowStartX, ArrowStartY: Integer;

  {These store the old line do we can see the arror}
  OldPointX, OldPointY: Integer;

implementation

{$R *.DFM}

procedure DrawArrow(FromX, FromY, ToX, ToY, Size, Width : Integer);

{ *** DrawArrow Procedure  ***
  Written By Scott M. Straley (straley@fast.net) -- March 15, 1995}

var
  Line1, Line2, ShortLine1, ShortLine2, ArrowX,
    ArrowY, Point1X, Point1Y, Point2X, Point2Y: Integer;

  Angle : Real;
begin

  {determining angle of X2 of line based on:

     X1
     |\
     | \  hypotneus
  L1 |  \
     |   \
     -----X2
       L2                                     }

  Line1 := (FromY-ToY);
  Line2 := (FromX-ToX);

  {We need this code to prevent DivByZero errors}

  if (Line2 <> 0) then
  begin
    Angle := arctan(Line1/Line2);
  end else
  begin
    if Line1 > 0 then
        Angle := -1.5707
    else
        Angle := 1.5707;
  end;

  {now determine where the back of the arrow is}

  if (ToX>FromX) then
  begin
    ShortLine1 := Round(Size * sin(Angle));
    ShortLine2 := Round(Size * cos(Angle));
    ArrowX := ToX - ShortLine2 ;
    ArrowY := ToY - ShortLine1 ;
  end
  else
  begin
    ShortLine1 := Round(Size * sin(Angle));
    ShortLine2 := Round(Size * cos(Angle));
    ArrowX := ToX + ShortLine2 ;
    ArrowY := ToY + ShortLine1 ;
  end;

  {now determine points perpendictular to the
   arrow line}

  Point1X := ArrowX - Round(Width * ( sin(Angle)));
  Point1Y := ArrowY + Round(Width * ( cos(Angle)));
  Point2X := ArrowX + Round(Width * ( sin(Angle)));
  Point2Y := ArrowY - Round(Width * ( cos(Angle)));


  ArrowForm.Canvas.MoveTo (FromX, FromY);
  ArrowForm.Canvas.LineTo (ToX, ToY);
  ArrowForm.Canvas.Polygon([Point(Point2X, Point2Y), Point(Point1X, Point1Y),
    Point(ToX, ToY)]);


end;

procedure TArrowForm.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

  {This sets the start of the arrow, and zeros out the "last place" the cursor
   was for drawing the "guiding line" used in the TArrowForm.FormMouseMove
   procedure.}

  ArrowStartX := X;
  ArrowStartY := Y;
  OldPointX := X;
  OldPointY := Y;
end;

procedure TArrowForm.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  {You can adjust the last two settings, they are the size and width of
   the arrowhead.  Also, setting ArrowForm.Canvas.Pen.Color will change the
   color of the line, and setting ArrowForm.Canvas.Brush.Color will change the
   color of the arrowhead.}
  ArrowForm.Canvas.Pen.Color := clBlue;
  ArrowForm.Canvas.Brush.Color := clLime;
  DrawArrow(ArrowStartX,ArrowStartY,OldPointX,OldPointY,10,5);

  {This needs to be set back for the "guiding line" to work, otherwise you
   can disregard this setting.}
  ArrowForm.Canvas.Pen.Color := clBlack;

end;

procedure TArrowForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if (OldPointX <> X) and (OldPointY <> Y) and (ssLeft in Shift) then
  begin

     {This code draws a line which is the inverse of the screen, and erases
      it when the cursor is moved}

     ArrowForm.Canvas.Pen.Mode := pmMergePenNot;
     ArrowForm.Canvas.MoveTo (ArrowStartX, ArrowStartY);
     ArrowForm.Canvas.LineTo (OldPointX, OldPointY);
     OldPointX := X;
     OldPointY := Y;
     ArrowForm.Canvas.MoveTo (ArrowStartX, ArrowStartY);
     ArrowForm.Canvas.LineTo (OldPointX, OldPointY);
     ArrowForm.Canvas.Pen.Mode := pmCopy;
  end;

end;

end.
