% DanMax ver. 1.0
%
%          ----------------------------------------------------
%          MENUS.CTL -- The menus control file for Maximus-CBCS
%          ----------------------------------------------------
%
% This file controls all of the aspects of Max's menus, including
% the actions performed by each option, the overall menu structure,
% and the appearance of each menu.
%
% Each menu definition is started by a "Menu" keyword.  Immediately after
% the word "Menu" should be the filename to use for that menu file.  The
% .MNU extension will be added automatically.
%
% The only two menu names that Maximus requires are "MAIN" and "EDIT".
% The MAIN menu is called as soon as a user has logged on, and the
% EDIT menu is called whenever the user enters the BORED message editor.
% 
% Other than those two, you are completely free to name your menus as
% you wish.  Since you define the links between menus, the names you
% use for your other menus is of no consequence.
%
% Also, you are completely free to put as many items on as many menus
% as you want, although it is recommended that you keep the general menu
% structure the same.  You can have up to a maximum of 127 separate menu
% options on each individual menu.

Menu MAIN0
        %
        % This option defines what the name of the menu will look like
        % on-screen, to the user.  This doesn't necessarily have to be
        % the same name as you specified above.

        Title   HOVEDMENU
        % (%t min. tilbage)

        % This option is used to specify a "type" for each menu.  These
        % menu types cause Maximus to display certain information before
        % the "Select:" prompt, such as the message area banner, the
        % information screen for the C)hange menu, and so on.  The
        % following MenuHeaders are supported by Maximus:
        %
        %       MenuHeader Message:   Displays a "Msg.area xx .. Description"
        %                             status line before each prompt.
        %
        %       MenuHeader File:      Displays a "File area yy .. Description"
        %                             status line before each prompt.
        %
        %       MenuHeader Change:    Displays the user's current settings,
        %                             which is usually what you'd find at
        %                             the C)hange Setup menu.

        MenuHeader      None

        % This next option defines a customized *.BBS file to display
        % _instead_ of the canned, Max-generated menu.  The file you
        % specify will be shown to callers who enter this menu whenever
        % the menu options would normally be displayed.  If no
        % file is given, Max will generate the menu on its own.
        %
        % This file can contain any of the special MECCA tokens that
        % you can use in a normal .MEC file.
        %
        % If you specify a MenuFile, it will be enabled for all help
        % levels by default.  However, if you wish to enable the
        % menu for certain help levels only (such as NOVICE and
        % REGULAR), simply add the names of the levels after the
        % filename.  For example, "MenuFile Misc\MenuMain Novice"
        % would show the MenuFle to novice callers only, and
        % the Max-generated menu would be shown to everyone else.
        % See the Max TechRef manual for more information on this
        % option.
        %
        % Maximus can also display a HeaderFile for each menu.
        % Please see the TechRef Manual for more information.

%       MenuFile        Misc\MenuMain

        % If you are using the customized .BBS MenuFile, then you must
        % tell Maximus how many lines on your screen that your custom
        % file takes.  If this value is not specified, or if it is incorrect,
        % then you will have problems with messages being scrolled off the
        % top of your screen because of your customized menufile.

%       MenuLength      14

        % This option is also only applicable if you're using a custom
        % *.BBS menufile.  As expected, if a user presses a key in the
        % middle of the menu with HOTFLASH turned on, the menu will abort
        % it's display, and jump to the option selected.  However, if
        % your *.BBS file has a coloured background, this operation may
        % cause the background to bleed into the rest of the screen.  The
        % solution is to specify an AVATAR colour number here, which will
        % be displayed BEFORE printing the key the user selected.  Normally,
        % this colour should have the background set to black, or whatever
        % colour your screen normally is.  An index of the AVATAR colour
        % codes (and their corresponding colours) can be found in the
        % MAX_REF.PRN manual.

%       MenuColour      15

        % This section of the control file defines the available
        % commands for this menu.

        % The name of the COMMAND to perform is in the left column.
        % This tells Maximus what it should do when this option is
        % selected.  Examples of commands are "Goodbye",
        % "Display_File" and "Msg_Browse".
        %
        % Following the command is an optional argument; some
        % commands need arguments, but others don't.  If the argument
        % contains any spaces (such as would a DOS command line),
        % then make sure to replace them with underscores, which will
        % get translated back into spaces when the menu is read back
        % in.  The only common commands which use arguments are
        % Display_File, Display_Menu and Area_Change.
        %
        % After the argument is that command's access level.  This
        % access level consists of a privilege level and an optional
        % set of keys.  A user will only be able to select that
        % option if his/her priv level is equal to or higher than the
        % specified level.  In addition, if you wish to restrict a
        % command to users which carry certain keys, simply place a
        % slash and a list of key numbers/letters after the privilege
        % level.  For example, to restrict a command so that only
        % Normal-level users with keys 1 and C can access a command,
        % use a priv level of "Normal/1C".
        %
        % Following the priv level is the command description.  This
        % description will be used when creating NOVICE-level menus,
        % and the first letter of that command will be used as the
        % selection character, so make sure that each command has a
        % unique first character.

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Display_Menu    Message%Y              Disgrace "Post-omrder"
  NoDsp Display_Menu    Message%Y              Disgrace "M"
        Display_Menu    File%Y                 Disgrace "Fil-omrder"
        Display_Menu    Change%Y               Disgrace "Din opstning"

        % The above three options tell Maximus to chain to a different
        % *.Mnu file, whose name is specified as an argument.  Please
        % make sure NOT to include a path before the name of your menu,
        % since Maximus will add that according to the currently-defined
        % menu path.

        Goodbye                                    Twit "G ud (log ud)"
        Statistics                             Disgrace "Statistik"
        Userlist                               Disgrace "Liste over brugere"
        Version                                Disgrace "Version af BBS"

        Display_File    Misc\YellReq           Disgrace "Kald p SysOp"
  NoDsp Yell                                   Disgrace "K"

        % The above options are fairly generic, and basically do what
        % they appear to do.

        % When selected, this option displays a *.BBS file to the user.
        % You can have as many of these custom files as you wish.

        Display_File    Misc\Bulletin          Disgrace "Bulletiner"

        % These commands display the off-line reader and SysOp menus.

        Display_Menu    Reader%Y               Disgrace "Off-line ls"
        Display_Menu    Sysop%Y                   Sysop "!Sysop menu"

        % The next commands are only of use to multi-line systems.
        % PLEASE SEE THE DOCUMENTATION BEFORE ENABLING THESE
        % COMMANDS!

%       Who_Is_On                              Disgrace "Hvem er p?"
 NoDsp  Display_Menu    Chat%Y                 Disgrace "/Chat Menu"

        % The following is the help file for the main menu.  Unless you
        % specify a help file, such as done below, users will NOT be able
        % to press `?' for help.

        Display_File    Hlp+Y\Main             Disgrace "?hjlp"

End Menu


Menu MESSAGE0

        Title  POST-MENU

        % To turn off the "Msg.area xxx ... asdf" display, but to still
        % have Max believe that this is a message menu, use
        % "SilentMenuHeader Message" instead of the line below.

        MenuHeader      Message

        % To display a custom file instead of the canned Max menu, use
        % this:

%       MenuFile        Misc\MenuMsg

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Area_Change     Message                Disgrace "Omrde"
  NoDsp Area_Change     Message                Disgrace "[" "["
  NoDsp Area_Change     Message                Disgrace "]" "]"
  NoDsp Area_Change     Message                Disgrace "A"
        Read_Next                              Disgrace "Nste brev"
        Read_Previous                          Disgrace "Forrige brev"
        Enter_Message                          Disgrace "Skriv brev"
        Msg_Reply                              Disgrace "Besvar brev"
        Msg_Browse                             Disgrace "Kig breve igennem"
        Msg_Change                             Disgrace "Lav om p brev"
        Read_Nonstop                           Disgrace "=Ls non stop"
        Read_Original                          Disgrace "-Ls original"
        Read_Reply                             Disgrace "+Ls svar"
        Msg_Current                            Disgrace "*Ls aktuelt brev"
        Msg_List                               Disgrace "Postliste"
        Msg_Tag                                Disgrace "Mrk omrder"
        Display_Menu    Main%Y                     Twit "Hovedmenu"
        Display_Menu    File%Y                     Twit "Til fil-omrde"
        Goodbye                                    Twit "G ud (log ud)"
  Local Msg_Kill                               Disgrace "!Slet brev"
 Matrix Msg_Kill                               Disgrace "!Slet brev"
        Msg_Upload                             Disgrace "Upload (send) brev"
        Forward                                Disgrace "Eftersend kopi"
        Msg_Hurl                                  Sysop "ZFlyt brev (hurl)"
        Xport                                     Sysop "Xport til disk"
        Msg_Edit_User                             Sysop "@Edit user"
  NoDsp Same_Direction                         Disgrace "|"
  NoDsp Read_Individual                        Disgrace "0"
  NoDsp Read_Individual                        Disgrace "1"
  NoDsp Read_Individual                        Disgrace "2"
  NoDsp Read_Individual                        Disgrace "3"
  NoDsp Read_Individual                        Disgrace "4"
  NoDsp Read_Individual                        Disgrace "5"
  NoDsp Read_Individual                        Disgrace "6"
  NoDsp Read_Individual                        Disgrace "7"
  NoDsp Read_Individual                        Disgrace "8"
  NoDsp Read_Individual                        Disgrace "9"
  Local Display_File    Hlp+Y\Msg              Disgrace "?hjlp"
 Matrix Display_File    Hlp+Y\Mail             Disgrace "?hjlp"
   Echo Display_File    Hlp+Y\Echo             Disgrace "?hjlp"
        %
End Menu

Menu FILE0

        Title  FIL-MENU

        % To turn off the "File area xxx ... asdf" display, but to still
        % have Max believe that this is a file menu, use
        % "SilentMenuHeader File" instead of the line below.

        MenuHeader      File

        % To display a custom file instead of the canned Max menu, use
        % this:

%       MenuFile        Misc\MenuFile

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Area_Change     File                   Disgrace "Omrde"
  NoDsp Area_Change     File                   Disgrace "[" "["
  NoDsp Area_Change     File                   Disgrace "]" "]"
  NoDsp Area_Change     File                   Disgrace "A"
        Locate                                 Disgrace "Eftersg en fil"
        File_Titles                            Disgrace "Fil-liste"
        Type                                   Disgrace "Kig i tekst-fil"
        Download                               Disgrace "Download (modtag)"
        Upload                                 Disgrace "Upload (send)"
        Statistics                             Disgrace "Statistik"
        Contents                               Disgrace "Indhold af fil"
        File_Tag                               Disgrace "Mrk filer"
        NewFiles                               Disgrace "Nye filer"
        Raw                                       Sysop "Raw directory"
        File_Kill                                 Sysop "!Kill file"
        File_Hurl                                 Sysop "*Hurl (move)"
        Override_Path                             Sysop "Path override"
        Display_Menu    Main%Y                     Twit "Hovedmenu"
        Display_Menu    Message%Y                  Twit "Til post-omrder"
        Goodbye                                    Twit "G ud (log ud)"
        Display_File    Hlp+Y\FileHelp         Disgrace "?hjlp"
        %
End Menu

Menu CHANGE0

        Title  DIN OPSTNING

        MenuHeader      Change

%       MenuFile        Misc\MenuChg

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Chg_Alias                                Hidden "Alias"
        Chg_Phone                              Disgrace "Telefon"
        Chg_City                               Disgrace "By"
        Chg_Password                           Disgrace "Kodeord"
        Chg_Help                               Disgrace "Niveau for hjlp"
        Chg_Nulls                              Disgrace "0Nuller"
        Chg_Width                              Disgrace "Skrmbredde"
        Chg_Length                             Disgrace "Linjer p skrmen"
        Chg_Tabs                               Disgrace "#Tabulering"
        Chg_Video                              Disgrace "Video mode"
        Chg_Editor                             Disgrace "FuldSkrmsEditor"
        Chg_Clear                              Disgrace "Rens skrmen"
        Chg_IBM                                Disgrace "IBM karakterer"
        Chg_Hotkeys                            Disgrace "!Hotkeys"
        Chg_Language                           Disgrace "@Sprog"
  NoDsp Display_Menu    Change%Y               Disgrace "@"
        Chg_Userlist                           Disgrace "%I brugerlisten"
        Chg_Protocol                           Disgrace "Protokol"
        Chg_Archiver                           Disgrace "&Pakkemetode"
        Chg_FSR                                Disgrace "+FuldSkrmsLs"
        Chg_More                               Disgrace "*Mere?'"
        Display_Menu    Main%Y                     Twit "Hovedmenu"
  NoDsp Display_Menu    Main%Y                     Twit "M"
  NoDsp Display_Menu    Main%Y                     Twit "Q"
  NoDsp Display_Menu    Main%Y                     Twit "|"
        Display_File    Hlp+Y\Change           Disgrace "?hjlp"
        %
End Menu

Menu EDIT0

        Title SKRIV/RET/LS BREVE  

%       MenuFile        Misc\MenuEdit

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Edit_Save                                  Twit "Gem brev"
        Edit_Abort                                 Twit "Drop brev"
        Edit_List                                  Twit "Vis brev"
        Edit_Edit                                  Twit "Ret linje"
        Edit_Insert                                Twit "Indst linje"
        Edit_Delete                                Twit "Slet linje"
        Edit_Quote                                 Twit "Citat"
        Edit_Continue                              Twit "Fortst"
        Edit_To                                    Twit "Til"
        Edit_Subj                                  Twit "Emne"
        Edit_From                                 Sysop "From"
        Edit_Handling                             Sysop "Handling"
        Read_DiskFile                             Sysop "*Read from disk"
        Display_File    Hlp+Y\Editor               Twit "?hjlp"

End Menu


Menu CHAT0

        Title  CHAT/SNAK

        MenuHeader      Chat
%       MenuFile        Misc\MenuChat

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Chat_CB                                Disgrace "CB Chat"
        Chat_Page                              Disgrace "Kald bruger"
        Chat_Pvt                               Disgrace "Svar p kald"
        Chat_Toggle                            Disgrace "Veksle status"
        Display_Menu    MAIN%Y                 Disgrace "Hovedmenu"
        Goodbye                                Disgrace "G ud (log ud)"
        Display_File    Misc\ChatHelp          Disgrace "?hjlp"
End Menu


Menu READER0

        Title  LS OFF-LINE
        HeaderFile      Misc\OLR_Hdr

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Msg_Tag                                Disgrace "Mrk omrde"
        Msg_Browse                             Disgrace "Download nye breve" "mnp"
        Msg_Upload_QWK                         Disgrace "Upload (send) svar"
        Chg_Protocol                           Disgrace "Protokol"
        Chg_Archiver                           Disgrace "&Pakkemetode"
        Display_Menu    Main%Y                     Twit "Hovedmenu"
        Goodbye                                    Twit "G ud (log ud)"
        Display_File    Hlp+Y\OLR              Disgrace "?hjlp"
  NoDsp Display_Menu    Main%Y                     Twit "|"
End Menu


Menu SYSOP0

        Title  SYSOP MENU

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        % This command invokes the internal Maximus user editor.

        User_Editor                                Sysop "User Editor"

        % This tells Maximus that you want to execute an external
        % program (in this case, COMMAND.COM) when the `O' menu option
        % is selected.  Other options are available, such as `Xtern_Dos'
        % (which can run .BAT or .CMD files) and `Xtern_Erlvl'
        % (which completely unloads Maximus from memory).
        %
        % Also, when specifying the command/errorlevel to execute,
        % don't forget to use underscores instead of spaces!
        %
        % Examples:
        %
        %   Xtern_Run   C:\Max\Bonk_/XN       Sysop "Nodelist editor"
        %   Xtern_Dos   D:\Path\Runme.Bat      Twit "Run XYZ program"
        %   Xtern_Erlvl 45_Ongame.Bat      Disgrace "On-line Games"

        % If you're running 4DOS, replace the following
        % "Command.Com" with "4Dos.Com".

UsrRemote Xtern_Run     Command.Com_>com%P_<com%P   Sysop "OS Shell"
UsrLocal  Xtern_Run     Command.Com                 Sysop "OS Shell"

        Display_Menu    Main%Y                      Sysop "Hovedmenu"
  NoDsp Display_Menu    Main%Y                      Sysop "Q"
  NoDsp Display_Menu    Main%Y                      Sysop "|"
End Menu


Menu MAIN1

        Title  MAIN MENU

        %
        %       MenuHeader Message:   Displays a "Msg.area xx .. Description"
        %                             status line before each prompt.
        %
        %       MenuHeader File:      Displays a "File area yy .. Description"
        %                             status line before each prompt.
        %
        %       MenuHeader Change:    Displays the user's current settings,
        %                             which is usually what you'd find at
        %                             the C)hange Setup menu.

        MenuHeader      None


%       MenuFile        Misc\MenuMain

%       MenuLength      14

%       MenuColour      15

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Display_Menu    Message%Y              Disgrace "Message Areas"
        Display_Menu    File%Y                 Disgrace "File Areas"
        Display_Menu    Change%Y               Disgrace "Change Setup"

        % The above three options tell Maximus to chain to a different
        % *.Mnu file, whose name is specified as an argument.  Please
        % make sure NOT to include a path before the name of your menu,
        % since Maximus will add that according to the currently-defined
        % menu path.

        Goodbye                                    Twit "Goodbye (log off)
        Statistics                             Disgrace "Statistics"
        Userlist                               Disgrace "UserList"
        Version                                Disgrace "Version of BBS"

        Display_File    Misc\YellReq           Disgrace "Yell for SysOp"
  NoDsp Yell                                   Disgrace "Y"

        Display_File    Misc\Bulletin          Disgrace "Bulletins"

        Display_Menu    Reader%Y               Disgrace "Off-line reader"
        Display_Menu    Sysop%Y                   Sysop "!Sysop menu"


%       Who_Is_On                              Disgrace "Who is On"
  NoDsp Display_Menu    Chat%Y                 Disgrace "/Chat Menu"

        Display_File    Hlp+Y\Main             Disgrace "?help"

End Menu


Menu MESSAGE1

        Title   MESSAGE MENU

        MenuHeader      Message

%       MenuFile        Misc\MenuMsg

        Area_Change     Message                Disgrace "Area change"
  NoDsp Area_Change     Message                Disgrace "[" "["
  NoDsp Area_Change     Message                Disgrace "]" "]"
        Read_Next                              Disgrace "Next message"
        Read_Previous                          Disgrace "Previous message"
        Enter_Message                          Disgrace "Enter message"
        Msg_Reply                              Disgrace "Reply to a message"
        Msg_Browse                             Disgrace "Browse messages"
        Msg_Change                             Disgrace "Change current msg"
        Read_Nonstop                           Disgrace "=ReadNonStop"
        Read_Original                          Disgrace "-ReadOriginal"
        Read_Reply                             Disgrace "+ReadReply"
        Msg_Current                            Disgrace "*ReadCurrent"
        Msg_List                               Disgrace "List (brief)"
        Msg_Tag                                Disgrace "Tag areas"
        Display_Menu    Main%Y                     Twit "Main menu"
        Display_Menu    File%Y                     Twit "Jump to file areas"
        Goodbye                                    Twit "Goodbye (log off)"
  Local Msg_Kill                               Disgrace "Kill (delete) msg"
 Matrix Msg_Kill                               Disgrace "Kill (delete) msg"
        Msg_Upload                             Disgrace "Upload a message"
        Forward                                Disgrace "Forward (copy)"
        Msg_Hurl                                  Sysop "Hurl (move)"
        Xport                                     Sysop "Xport to disk"
        Msg_Edit_User                             Sysop "@Edit user"
  NoDsp Same_Direction                         Disgrace "|"
  NoDsp Read_Individual                        Disgrace "0"
  NoDsp Read_Individual                        Disgrace "1"
  NoDsp Read_Individual                        Disgrace "2"
  NoDsp Read_Individual                        Disgrace "3"
  NoDsp Read_Individual                        Disgrace "4"
  NoDsp Read_Individual                        Disgrace "5"
  NoDsp Read_Individual                        Disgrace "6"
  NoDsp Read_Individual                        Disgrace "7"
  NoDsp Read_Individual                        Disgrace "8"
  NoDsp Read_Individual                        Disgrace "9"
  Local Display_File    Hlp+Y\Msg              Disgrace "?help"
 Matrix Display_File    Hlp+Y\Mail             Disgrace "?help"
   Echo Display_File    Hlp+Y\Echo             Disgrace "?help"
        %
End Menu

Menu FILE1

        Title  FILE MENU

        MenuHeader      File

%       MenuFile        Misc\MenuFile

        Area_Change     File                   Disgrace "Area change"
  NoDsp Area_Change     File                   Disgrace "[" "["
  NoDsp Area_Change     File                   Disgrace "]" "]"
        Locate                                 Disgrace "Locate a file"
        File_Titles                            Disgrace "File titles"
        Type                                   Disgrace "View text file"
        Download                               Disgrace "Download (receive)"
        Upload                                 Disgrace "Upload (send)"
        Statistics                             Disgrace "Statistics"
        Contents                               Disgrace "Contents (archive)"
        File_Tag                               Disgrace "Tag (queue) files"
        NewFiles                               Disgrace "New files scan"
        Raw                                       Sysop "Raw directory"
        File_Kill                                 Sysop "Kill file"
        File_Hurl                                 Sysop "Hurl (move)"
        Override_Path                             Sysop "Override path"
        Display_Menu    Main%Y                     Twit "Main menu"
        Display_Menu    Message%Y                  Twit "Jump to msg. areas"
        Goodbye                                    Twit "Goodbye (log off)"
        Display_File    Hlp+Y\FileHelp         Disgrace "?help"
        %
End Menu

Menu CHANGE1

        Title    CHANGE MENU

        MenuHeader      Change

%       MenuFile        Misc\MenuChg

        Chg_Alias                                Hidden "Alias"
        Chg_Phone                              Disgrace "#Telephone no."
        Chg_City                               Disgrace "City"
        Chg_Password                           Disgrace "Password"
        Chg_Help                               Disgrace "Help level"
        Chg_Nulls                              Disgrace "Nulls"
        Chg_Width                              Disgrace "Width"
        Chg_Length                             Disgrace "Length"
        Chg_Tabs                               Disgrace "Tabs"
        Chg_Video                              Disgrace "Video mode"
        Chg_Editor                             Disgrace "FullScrnEdit"
        Chg_Clear                              Disgrace "Screen clear"
        Chg_IBM                                Disgrace "IBM characters"
        Chg_Hotkeys                            Disgrace "!Hotkeys"
        Chg_Language                           Disgrace "@Language"
  NoDsp Display_menu    Change%Y               Disgrace "@"
        Chg_Userlist                           Disgrace "%ShowInUserlist"
        Chg_Protocol                           Disgrace "$Protocol default"
        Chg_Archiver                           Disgrace "&Archiver default"
        Chg_FSR                                Disgrace "^FullScrnRead"
        Chg_More                               Disgrace "*More Prompt"
        Display_Menu    Main%Y                     Twit "Main Menu"
  NoDsp Display_Menu    Main%Y                     Twit "Q"
  NoDsp Display_Menu    Main%Y                     Twit "|"
        Display_File    Hlp+Y\Change           Disgrace "?help"
        %
End Menu

Menu EDIT1

        Title   EDIT MENU

%       MenuFile        Misc\MenuEdit

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Edit_Save                                  Twit "Save Message"
        Edit_Abort                                 Twit "Abort Message"
        Edit_List                                  Twit "List Message"
        Edit_Edit                                  Twit "Edit Line"
        Edit_Insert                                Twit "Insert Line"
        Edit_Delete                                Twit "Delete Line"
        Edit_Quote                                 Twit "Quote message"
        Edit_Continue                              Twit "Continue"
        Edit_To                                    Twit "To"
        Edit_Subj                                  Twit "JsubJect"
        Edit_From                                 Sysop "From"
        Edit_Handling                             Sysop "Handling"
        Read_DiskFile                             Sysop "Read from disk"
        Display_File    Hlp+Y\Editor               Twit "?help"
        %
End Menu


Menu CHAT1

        Title   CHAT MENU

        MenuHeader      Chat
%       MenuFile        Misc\MenuChat

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Chat_CB                                Disgrace "CB Chat"
        Chat_Page                              Disgrace "Page User"
        Chat_Pvt                               Disgrace "Answer Page"
        Chat_Toggle                            Disgrace "Toggle Status"
        Display_Menu    MAIN%Y                 Disgrace "Main Menu"
        Goodbye                                Disgrace "Goodbye (log off)"
        Display_File    Misc\ChatHelp          Disgrace "?help"
End Menu


Menu READER1

        Title   READER MENU

        HeaderFile      Misc\OLR_Hdr

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        Msg_Tag                                Disgrace "Tag area"
        Msg_Browse                             Disgrace "Download new msgs" "tnp"
        Msg_Upload_QWK                         Disgrace "Upload replies"
        Chg_Protocol                           Disgrace "Protocol default"
        Chg_Archiver                           Disgrace "Archiver default"
        Display_Menu    Main%Y                     Twit "Main menu"
        Goodbye                                    Twit "Goodbye (log off)"
        Display_File    Hlp+Y\OLR              Disgrace "?help"
  NoDsp Display_Menu    Main%Y                     Twit "|"
End Menu


Menu SYSOP1

        Title   SYSOP MENU

        % Name of cmd    Optional arguments      Priv.   Command as it
        % to execute     for cmd, if any         Level   appears to user
        % ------------  --------------------- --------- -----------------

        % This command invokes the internal Maximus user editor.

        User_Editor                                Sysop "User Editor"

        % This tells Maximus that you want to execute an external
        % program (in this case, COMMAND.COM) when the `O' menu option
        % is selected.  Other options are available, such as `Xtern_Dos'
        % (which can run .BAT or .CMD files) and `Xtern_Erlvl'
        % (which completely unloads Maximus from memory).
        %
        % Also, when specifying the command/errorlevel to execute,
        % don't forget to use underscores instead of spaces!
        %
        % Examples:
        %
        %   Xtern_Run   C:\Max\Bonk_/XN       Sysop "Nodelist editor"
        %   Xtern_Dos   D:\Path\Runme.Bat      Twit "Run XYZ program"
        %   Xtern_Erlvl 45_Ongame.Bat      Disgrace "On-line Games"

        % If you're running 4DOS, replace the following
        % "Command.Com" with "4Dos.Com".

UsrRemote Xtern_Run     Command.Com_>com%P_<com%P   Sysop "OS Shell"
UsrLocal  Xtern_Run     Command.Com                 Sysop "OS Shell"

        Display_Menu    Main%Y                      Sysop "Main menu"
  NoDsp Display_Menu    Main%Y                      Sysop "Q"
  NoDsp Display_Menu    Main%Y                      Sysop "|"
End Menu


