/*  Where utility using a singly linked list  */



#include <io.h>
#include <dos.h>
#include <dir.h>
#include <alloc.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <process.h>

#define TRUE 	1
#define FALSE 	0

/* function prototypes */
int check_args(int argc, char *argv[]);
void expand(char *file);
void report_options(void);
/* end prototypes */

/*  Declaration of linked list structure  */
typedef struct S_WHLIST {
	char *name;
	int type;
	struct S_WHLIST *next;
} WHLIST;

char *f_type[5] = {"file","directory","hidden file","system file",
				   "hidden system file"};
WHLIST *current;
WHLIST *front;
int SYSTEM = FALSE;
int HIDDEN = FALSE;
int EXPAND = TRUE;
int sx, sy, num_files=0;
char PATH[80] = "";

void main(int argc, char *argv[])
{
	int flags;
	char ch = 'y';

	if (argc == 1) {
		report_options();
		exit(0);
	}
	sx = wherex(); sy = wherey();
	current = calloc(1,sizeof(WHLIST));
	front = current;
	flags = check_args(argc, argv);
	current = front;

	gotoxy(sx,sy); clreol();
	printf("Matched %d file%c:\n",num_files,((num_files == 1) ? '\0':'s'));
	while (current->next != NULL) {
		   printf("%s %s\n",f_type[current->type],current->name);
		   current = current->next;
	}
}

int check_args(int argc, char *argv[])
{
	int loop, check, val = FALSE;

	for (loop=1;loop<argc;++loop) {
	   if (argv[loop][0] == '-') {
		 check = 1;
		 while (argv[loop][check]) {
			switch (argv[loop][check]) {
			   default : printf("\nrm: unknown option %s\n",argv[loop]);
			}
			check++;
		 }
	   }
	}

	for (loop=1;loop<argc;++loop)
	   if (argv[loop][0] != '-') expand(argv[loop]);

	return(val);
}

void expand(char *file)
{
	struct ffblk ff;
	int done;
	int s_type = FA_DIREC;
	char SAVE[80];

	if (EXPAND) {
		gotoxy(sx,sy);
		printf("Scanning: %s...",PATH); clreol();
		done = findfirst("*.*",&ff,FA_DIREC);
		while (!done) {
			if ((ff.ff_attrib == FA_DIREC) && (ff.ff_name[0] != '.')) {
			   strcpy(SAVE,PATH);
			   if (strlen(PATH) != 0) strcat(PATH,"\\");
			   strcat(PATH,ff.ff_name);
			   chdir(ff.ff_name);
			   expand(file);
			   chdir("..");
			   strcpy(PATH,SAVE);
			}
			done = findnext(&ff);
		}
	}
	if (HIDDEN) s_type = (s_type | FA_HIDDEN);
	if (SYSTEM) s_type = (s_type | FA_SYSTEM);
	done = findfirst(file,&ff,s_type);
	while (!done) {
		switch (ff.ff_attrib) {
		   case FA_DIREC : current->type = 1; break;
		   case FA_HIDDEN: current->type = 2; break;
		   case FA_SYSTEM: current->type = 3; break;
		   case (FA_SYSTEM | FA_HIDDEN): current->type = 4;break;
		   default       : current->type = 0; break;
		}
		if (ff.ff_name[0] != '.') {
		   current->name = calloc(1,strlen(ff.ff_name)+strlen(PATH)+3);
		   if (strlen(PATH) > 0) {
			  strcpy(current->name,PATH);
			  strcat(current->name,"\\");
		   }
		   strcat(current->name,ff.ff_name);
		   current->next = calloc(1,sizeof(WHLIST));
		   current = current->next;
		   num_files++;
		}
		done = findnext(&ff);
	}
}

void report_options(void)
{
	printf("\nWHERE  locate files  v1.0\n");
	printf("      usage:  where [options] file <file...>\n");
	printf("      options:\n");
	putch('\n');
}
