#include <dos.h>
#include <bios.h>
#include <stdio.h>


void interrupt ( *Old09Handler )(...);          // Variables to hold
void interrupt ( *Old1BHandler )(...);          // Old vectors' address



/* ------------------------------------------------------------------ */
/* INT 23 is basically triggered either when the DOS Internal Break   */
/* Flag is set ( we'll handle this through through our 1B handler ) or*/
/* when particular scan codes make their way to the keyboard buffer.  */
/* The following 9 Handler prevents the Original 9 Handler from       */
/* stuffing the keyboard buffer with one of the scan codes ( 2E03 )   */
/* by smuggling the key combination ( CTRL-C ) away.             B.B.  */
/* ------------------------------------------------------------------ */
void interrupt New09Handler(...)
{
    _AL = inportb( 0x60 );                      // Read the Scan Code
    if ( _AL == 0x2E )                          // Is it a C ?
    {
        _AH = 0x02;                             // Check the Shift
        geninterrupt( 0x16 );                   // Status using BIOS
        if ( _AX & 0x04 )                       // Is Control Held Down ?
        {
            _AL  = inportb( 0x61 );             // Reset the Keyboard
            _AH  = _AL;
            _AL |= 0x80;
            outportb( 0x61, _AL );
            _AL  = _AH;
            outportb( 0x61, _AL );
            outportb( 0x20, 0x20 );             // EOI to 8259
            _AX = 0x0E07;                       // Beep to indicate that
            geninterrupt( 0x10 );               // we smuggled Ctrl-C !
            return;                             // Do not chain !!
        }
    }
    /* -------------------------------------------------------------- */
    /* Although most users do not realize it, hitting Ctrl-2 or       */
    /* Alt-keypad-3 results in the same interrupt as hitting Ctrl-C,  */
    /* including the ^C display.  Therefore the above detection logic */
    /* must be repeated for the additional key combinations mentioned */
    /* prior to chaining to the original INT-9 Handler for a          */
    /* comprehensive and foolproof implementation!              B.B.  */
    /* -------------------------------------------------------------- */

    Old09Handler();                             // Chain to Old Handler
}



/* ------------------------------------------------------------------ */
/* The following 1B handler basically does what the original 1B BIOS  */
/* Handler does: IRET;   This enables us to bypass the vector which   */
/* DOS installs and which sets DOS' INTERNAL BREAK FLAG...            */
/* ------------------------------------------------------------------ */
void interrupt New1BHandler(...)
{
}


int main( void )
{

    Old09Handler = getvect( 0x09 );             // Save the Original
    Old1BHandler = getvect( 0x1B );             // Vectors

    setvect( 0x09, New09Handler );              // Install new
    setvect( 0x1B, New1BHandler );              // Handlers

    puts( "Please hit the ESC key to terminate..." );

    /* -------------------------------------------------------------- */
    /* The following code merely reads Console input and displays     */
    /* the characters read in.   The functions used are  21/8, 21/2.  */
    /* Both of thsese DOS I/O interrupt check for the Break flag.     */
    /* They are therefore ideal for a test case.   As mentioned above,*/
    /* Ctrl-2 or Alt-keyboard-3 will still trigger 23h unless the     */
    /* INT 9 handler smuggles those scan codes too.  However, Ctrl-C  */
    /* will not get by !                                        B.B.  */
    /* -------------------------------------------------------------- */

    LABEL:
    asm {
                mov     ah, 8h
                int     21h
                or      al, al
                jz      LABEL
                mov     dl, al
                mov     ah, 2
                int     21h
                cmp     dl, 27
                jne     LABEL
        }

    setvect( 0x09, Old09Handler );              // Restore Original
    setvect( 0x1B, Old1BHandler );              // Handlers

    return( 0 );
}
