#include "control.hpp"


void Control::CreateControl(LPSTR ClassName,HWND PhWnd, int Id, LPSTR pText,DWORD Style,
	int x, int y, int width, int height)
{

  hWnd=GetDlgItem(PhWnd,Id);  //May have been created by
                               //a dialog resource
  if (!hWnd) {
    hWnd = CreateWindow(ClassName,pText,Style ,
	    x,y,width,height,
	    PhWnd,(HMENU)Id,hInst,NULL);
    if (!hWnd) Error(IDS_APPLERROR, ClassName);
  }
  PutWin(hWnd,this);
//#ifdef WIN32
//  DefaultHandler = (WNDPROC) GetWindowLong(hWnd,GWL_WNDPROC);
//#else
  DefaultHandler = (FARPROC) GetWindowLong(hWnd,GWL_WNDPROC);
//#endif

}

Control::~Control()
{
  DelWin(hWnd);
}

void Control::SetRedraw(BOOL bRedraw){
  SendMessage(hWnd,WM_SETREDRAW,bRedraw,0);
  if (!bRedraw) InvalidateRect(hWnd,NULL,FALSE);
}


int ItemMeasurement::itemWidth=0;
int ItemMeasurement::itemHeight=0;


ItemMeasurement::ItemMeasurement(int Height, int Width)
{
  itemWidth=Width;
  itemHeight=Height;
}

ItemMeasurement::~ItemMeasurement()
{
  itemWidth=itemHeight=0;
}


