{
 Author:    Craig Ward
 Copyright: none - public domain

 Date:      21/5/96

 Version:   1.0

 Overview:  system dialog.
*******************************************************************************}
unit Cwauddlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Grids, Outline, Cwbutton, ExtCtrls, sysutils, dialogs, messages;


type
  TAuditDlg = class(TForm)
    Bevel1: TBevel;
    cwButton1: TcwButton;
    cwButton2: TcwButton;
    outAudit: TOutline;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Label1: TLabel;
    procedure cwButton1Click(Sender: TObject);
    procedure cwButton2Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
    procedure SetTextFile(const value: string);
    function mFileSize(const sFile: string): boolean;
  public
    { Public declarations }
    FTextFile: string;
    property TextFile: string read FTextFile write SetTextFile;
  end;

var
  AuditDlg: TAuditDlg;

implementation

{$R *.DFM}

uses
 cw_apps;

{***buttons********************************************************************}

{close}
procedure TAuditDlg.cwButton1Click(Sender: TObject);
begin
 modalResult := mrOK;
end;

{help}
procedure TAuditDlg.cwButton2Click(Sender: TObject);
begin
 Application.HelpCommand(HELP_CONTEXT,helpContext);
end;

{print}
procedure TAuditDlg.SpeedButton2Click(Sender: TObject);
var
 lpszFile: pChar;
begin
 lpszFile := StrAlloc(fsMaxFullFileName);
 try
  {use the /p switch, which forces notepad to print}
  StrPCopy(lpszFile,'notepad.exe /p '+FTextFile);
  WinExec(lpszFile,SW_HIDE);
 finally
  StrDispose(lpszFile);
 end;
end;

{purge}
procedure TAuditDlg.SpeedButton1Click(Sender: TObject);
var
 tF: file;
begin
 if FTextFile <> '' then
  if FileExists(FTextFile) then
   begin
    AssignFile(tF,FTextFile);
    Rewrite( tF );   {forces new file to be created}
    CloseFile(tF);
    {re-load}
    outAudit.lines.clear;
    if mFileSize(FTextFile) then
     outAudit.LoadFromFile(FTextFile);
   end;
end;


{***VCL preferences************************************************************}

{set text file}
procedure TAuditDlg.SetTextFile(const value: string);
begin
 if value <> FTextFile
  then
   begin
    FTextFile := value;
    if mFileSize(FTextFile) then
     outAudit.LoadFromFile(FTextFile);
   end;
end;

{***I\O************************************************************************}

{check file size - if greater than 64k then return false}
function TAuditDlg.mFileSize(const sFile: string): boolean;
var
 tc: file of char;
begin
 result := false;
 if fileExists(sFile) then
  begin
   AssignFile(tc,sFile);
   reset(tc);
   if FileSize(tc) > 65535 then
    result := false
   else
    result := true;
   CloseFile(tc);
  end;
end;

{}
end.
