/* REXX - Installation */
parse arg path
Signal on Halt
name = 'CutIt'
files.0 = 2; files.1 = 'cutit.exe'; files.2 = 'cutit.ico'
exe = 1
note = '0d0a'x ,
 'This program requires the runtime module VROBJ.DLL from WATCOM''s VX-REXX.' ,
 '0d0a'x ,
 'It must be located in a directory in the LIBPATH config.sys entry.' ,
 ''

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

if path = '' then do
  ret = SysIni('SYSTEM', 'FolderWorkareaRunningObjects', 'ALL:', 'Desktop')
  if ret <> '' | Desktop.0 <> 1 then do                                    
    say 'Error locating Desktop, C:\cutit will be used as a default'
    path = 'C:\' || name
  end
  else path = left(Desktop.1, 3) || name
end

r = 0
p = ''
do until p = ''
say path
  if SysFileTree(path, 'dir.', 'DO') then do
    say '*** Error ***'
    r = 99
  end
  if dir.0 > 0 then
    msg = 'EXISTS.'
  else msg = 'will be CREATED.'
  say name 'will be installed in' translate(path) || '. The directory' msg
  say 'Press <Enter> to accept, <Ctrl-C><Enter> to cancel or type a new directory path'
  p = strip(linein())
  if p <> '' then path = p
end

path = strip(path, 'T', '\')
if dir.0 = 0 then do
  '@md 1>nul 2>nul' path
  if rc <> 0 then do
    say '*** ERROR *** Could not create directory' path
    r = 99
  end
end

if directory() <> path then
  do i = 1 to files.0
    '@copy' files.i path
  end

setup = 'EXENAME=' || path || '\' || files.exe || ';STARTUPDIR=' || path
if SysCreateObject('WPProgram', name, '<WP_DESKTOP>', setup, 'F') then
  say name 'has been created on your DESKTOP.'
else do
 say 'The program object' name 'could not be created, possible duplicate'
 r = 99
end
 
if r = 0 then say note
'@pause'
return r
halt:
say 'Cancelled'
