{  CutUser v1.0 Source Code
   written and released by
   Douglas Good
   (c)1992 P/S Programming
   All rights reserved

   Written for the Renegade Bulletin Board System.  
   Conversion to other BBS systems is welcomed, as long as the 
   original author is credited.  Compile with Turbo Pascal v5.0+

   You are hereby granted permission to modify and compile this source
   code, provided that 1) You do not release the compiled code to the 
   general public, and 2) that no cost is associated with any program
   which uses a portion of this source code.

   This source code is declared as Freeware and may be copied and used
   without costs, royalty fees, or the donation of your firstborn.

   The author assumes no responsibility, in part or in whole, for the use
   of this source code or executable files generated by this source code.
   There are no warranties, either implied or expressed, attached to this
   source code or the executable files generated by this source code.

   Use this code at your own risk, or do not use this code.
}


uses crt;
{$I records.pas}        { The record structure for Renegade BBS }
{$I cutusr.pas}         { TheDraw Screen Information            }

type userfile = file of userrec;             {  USERS.DAT       }
     statfile = file of generalrec;          {  RENEGADE.DAT    }
     screentype = array [0..3999] of byte;   {  Screen Array    }

var 
user,
newuser : userfile;
stat,
newstat : statfile;
users : userrec;
cutoff : integer;
screen : screentype absolute $B800:0000;
error : integer;

procedure process(var stat, newstat : statfile;
                  var user,newuser : userfile;
                  var error : integer);

var chara : char;
    strn : string;
    count,
    code : integer;
    stats: generalrec;

begin
  clrscr;
  error :=0;
  assign (stat,'renegade.dat');
  {$I-}
  reset (stat);
  {$I+}
  if ioresult = 0 then
     begin
       read (stat,stats);
       close(stat);
       repeat
          move(imagedata,screen,4000);
          gotoxy(53,12);
          textcolor(15);
          write(' ',stats.numusers-1);
          textcolor(7);
          write(')');
          textcolor(15);
          gotoxy(37,12);
          readln(strn);
          val(strn,cutoff,code);
       until (code = 0) and (cutoff < stats.numusers) and (cutoff >= 1);
             stats.numusers := cutoff;
             assign (user, stats.datapath + '\users.dat');
             {$I-}
             reset (user);
             {$I+}
             rename(user,stats.datapath + 'users.ps!');
             {$I-}
             assign (newuser,stats.datapath+'\users.dat');
             rewrite(newuser);
             {$I+}
             if ioresult = 0 then
              begin
                for count := 0 to cutoff do
                  begin
                    read (user,users);
                    write (newuser,users);
                  end;
                  close(user);
                  close(newuser);
                  rename(stat,'renegade.ps!');
                  assign(newstat,'renegade.dat');
                  {$I-}
                  rewrite(newstat);
                  {$I+}
                  if ioresult = 0 then
                    begin
                      stats.numusers := cutoff;
                      write(newstat,stats);
                      close(newstat);
                    end
                 else error := 2;
              end
                 else error := 2;
     end
        else error := 1;
end;


procedure handle_error(error : integer);
 begin
    clrscr;
    textcolor(28);
    Case error of
       1: begin
            gotoxy(20,11);
            writeln('RUN THIS FROM YOUR MAIN BBS DIRECTORY');
          end;
       2: writeln('ERROR opening user files.  Operation Failed.');
    end; {case}
  end;


begin  {main}
   process(stat, newstat, user,newuser, error);
   if error <> 0 then handle_error(error)
   else begin 
          clrscr;
          gotoxy(14,10);
          textcolor(10);
          writeln('USERS.DAT and RENEGADE.DAT files sucessfully modified!');
          textcolor(15);
          gotoxy(14,12);
          writeln('Now delete your USERS.IDX file, and run the BBS to test');
          gotoxy(14,13);
          writeln('the modifications.  Double check your user data before');
          gotoxy(14,14);
          writeln('you delete the backup files: USERS.PS! and RENEGADE.PS!');
          
        end    
end.  
