{************************************************************************
*
*	Custom Control Test Program With Bitmap Buttons
*
*	WRITTEN BY:		Shawn Aubrey Baker (aka sab)
*
*	COMPUSERVE ID:	76450,22
*
*	CREDITS:			This code is largely copied from the test program
*						supplied by Robert Norton with his bitmap button unit.
*
*	USE:				As you wish. Please send any comments and/or bug fixes
*						via mail to the above ID. IF IT DIES IT'S YOUR PROBLEM.
*
*	NOTES:			This file uses tabs = 3
*
*						This program will run in a TWindow by default. If you
*						set the conditional compilation name DIALOG then it
*						will run in a TDlgWindow and use the resource defined
*						in BTNTEST.RES.
*
*	THE END.
*
************************************************************************}

program ButtonTest;

uses	WinTypes,WinProcs,WObjects,Strings,Custom;

{$R btntest.res}

const

		id_Button1=101;
		id_Button2=102;
		id_Button3=103;
		id_Button4=104;
		id_Button5=105;
		id_Button6=106;

type

		PBitWindow=^TBitWindow;
{$IFDEF DIALOG}
		TBitWindow=object(TDlgWindow)
{$ELSE}
		TBitWindow=object(TWindow)
{$ENDIF}
			PB1,PB2,PB3,PB4:PBitButton;		{ bit buttons		}
			B1,B2:PButton;							{ normal buttons	}

			constructor	Init;
			destructor	Done; virtual;

			procedure	DoYes(var Msg:TMessage);
												virtual id_First + id_Button1;
			procedure	DoNo(var Msg:TMessage);
												virtual id_First + id_Button2;
			procedure	DoOk(var Msg:TMessage);
												virtual id_First + id_Button3;
			procedure	DoCancel(var Msg:TMessage);
												virtual id_First + id_Button4;
			procedure	DoHi(var Msg:TMessage);
												virtual id_First + id_Button5;
			procedure	DoBye(var Msg:TMessage);
												virtual id_First + id_Button6;
			end;

		PBtnApp=^TBtnApp;
		TBtnApp=object(TApplication)
			constructor	Init(AName: PChar);
			destructor	Done; virtual;

			procedure	InitMainWindow; virtual;
			end;

{------------------------------------------------------------------------
-------------------------------------------------------------------------
----										TBitApp Object								----
-------------------------------------------------------------------------
------------------------------------------------------------------------}

constructor TBtnApp.Init(AName:PChar);
begin
TApplication.Init(AName);
end;

destructor TBtnApp.Done;
begin
TApplication.Done;
end;

procedure TBtnApp.InitMainWindow;
begin
MainWindow:=New(PBitWindow,Init);
end;

{------------------------------------------------------------------------
-------------------------------------------------------------------------
----									TBitWindow Object								----
-------------------------------------------------------------------------
------------------------------------------------------------------------}

constructor TBitWindow.Init;
begin

{$IFDEF DIALOG}

TDlgWindow.Init(nil,'BIT_BUTTON_DIALOG');

PB1:=New(PBitButton,InitResource(@Self,id_Button1,
			PChar(1006),PChar(5006),PChar(3006)));
PB2:=New(PBitButton,InitResource(@Self,id_Button2,
			PChar(1007),PChar(5007),PChar(3007)));
PB3:=New(PBitButton,InitResource(@Self,id_Button3,
			PChar(1001),PChar(5001),PChar(3001)));
PB4:=New(PBitButton,InitResource(@Self,id_button4,
			PChar(1002),PChar(5002),PChar(3002)));
B1:=New(PButton,InitResource(@Self,id_Button5));
B2:=New(PButton,InitResource(@Self,id_Button6));

{$ELSE}

TWindow.Init(nil,'Button Test');

PB1:=New(PBitButton,Init(@Self,id_Button1,10,10,
			PChar(1006),PChar(5006),PChar(3006),false));
PB2:=New(PBitButton,Init(@Self,id_Button2,150,10,
			PChar(1007),PChar(5007),PChar(3007),false));
PB3:=New(PBitButton,Init(@Self,id_Button3,10,70,
			PChar(1001),PChar(5001),PChar(3001),true));
PB4:=New(PBitButton,Init(@Self,id_Button4,150,70,
			PChar(1002),PChar(5002),PChar(3002),false));
B1:=New(PButton, Init(@Self,id_Button5,'Hi',300,10,60,30,false));
B2:=New(PButton, Init(@Self,id_Button6,'Bye',300,70,60,30,false));
EnableKBHandler;

{$ENDIF}

end;

destructor TBitWindow.Done;
begin
Dispose(PB1,Done);
Dispose(PB2,Done);
Dispose(PB3,Done);
Dispose(PB4,Done);
Dispose(B1,Done);
Dispose(B2,Done);

{$IFDEF DIALOG}
TDlgWindow.Done;
{$ELSE}
TWindow.Done;
{$ENDIF}

end;

procedure TBitWindow.DoYes(var Msg:TMessage);
begin
MessageBox(hWindow,'Yes','You pushed:',mb_Ok);
end;

procedure TBitWindow.DoNo(var Msg:TMessage);
begin
MessageBox(hWindow,'No','You pushed:',mb_Ok);
end;

procedure TBitWindow.DoOk(var Msg:TMessage);
begin
MessageBox(hWindow,'OK','You pushed:',mb_Ok);
end;

procedure TBitWindow.DoCancel(var Msg:TMessage);
begin
MessageBox(hWindow,'Cancel','You pushed:',mb_Ok);
end;

procedure TBitWindow.DoHi(var Msg:TMessage);
begin
MessageBox(hWindow,'Hi','You pushed:',mb_Ok);
end;

procedure TBitWindow.DoBye(var Msg:TMessage);
begin
MessageBox(hWindow,'Bye','You pushed:',mb_Ok);
end;

{------------------------------------------------------------------------
-------------------------------------------------------------------------
----										Mainline										----
-------------------------------------------------------------------------
------------------------------------------------------------------------}

var	BtnApp:TBtnApp;

begin
BtnApp.Init('BitButton Test');
BtnApp.Run;
BtnApp.Done;
end.
