/***************************************************************
 * file: GUI.H
 * purpose: simple gui prototypes, defines and data structures
 * copyright: 1991 by David Weber.  All rights reserved.
 *  This software can be used for any purpose as object, library or executable.
 *  It cannot be sold for profit as source code.
 * history:
 *  12-17-91 - initial code
 *  01-31-93 - this code is now obsolete, see the CPP gui package
 **************************************************************/

#ifndef _GUI
#define _GUI

#ifdef DEBUG
#define FG_SYNCHRONIZED         /* allow zdb to check heap buffers */
#endif
#include <fg.h>

#include "keys.h"

/* --------- SYSTEM DEFAULTS --------- */

/* standard colors */
#define COLOR_SYSTEM_BACKGROUND FG_BLACK
#define COLOR_MESSAGE_BACKGROUND FG_RED
#define COLOR_MESSAGE_FOREGROUND FG_WHITE
#define COLOR_MENU_FOREGROUND FG_WHITE
#define COLOR_MENU_BACKGROUND FG_BLUE
#define COLOR_MENU_GRAY FG_GRAY
#define COLOR_MENU_HIGHLIGHT FG_LIGHT_CYAN
#define COLOR_MENU_FOCUS FG_LIGHT_GREEN
#define COLOR_DIALOG_FOREGROUND FG_LIGHT_WHITE
#define COLOR_DIALOG_BACKGROUND FG_CYAN
#define COLOR_DIALOG_HIGHLIGHT FG_LIGHT_CYAN
#define COLOR_DIALOG_SELECTION FG_LIGHT_GREEN
#define COLOR_DIALOG_GRAY FG_GRAY
#define COLOR_DIALOG_FOCUS FG_YELLOW



/* --------- GUI.C, MESSAGES AND OBJECTS --------- */

/* message box info */
#define MESSAGE_MAX_STR 80      /* maximum size of a message string */
#define MESSAGE_YN " Y/N?"      /* Y/N appendage */
#define MESSAGE_YES 'y'         /* Yes, lower case */
#define MESSAGE_NO 'n'          /* No, lower case */

/* message id defines */

/* system messages */
#define M_MIN_SYSTEM 0          /* minimum system message */
#define M_NONE 0                /* null message */
#define M_START 1               /* startup message */
#define M_QUIT 2                /* quit message */
#define M_MAX_SYSTEM 99         /* maximum system message */

/* input messages */
#define M_MIN_INPUT 100         /* minimum input message */
#define M_KEY 100               /* keyboard hit, key value in short_data.x */
#define M_MOUSE_LEFT 101        /* mouse left button went down, x,y coordinates in short_data */
#define M_MOUSE_CENTER 102      /* mouse center button went down, x,y coordinates in short_data */
#define M_MOUSE_RIGHT 103       /* mouse right button went down, x,y coordinates in short_data */
#define M_MAX_INPUT 199         /* maximum input message */

/* error messages, address of function causing error is found in message->data.ptr_data */
#define M_MIN_ERROR 200         /* minimum error message */
#define M_NULL_ERROR 200        /* an undefined error occurred */
#define M_NOMEM 201             /* memory allocation failed */
#define M_MESSAGE_OVERFLOW 202  /* message queue overflowed and messages were lost */
#define M_INVALID_PARMS 203     /* invalid parameters passed to a function */
#define M_NOT_OPEN 204          /* attempt to access an unopened object */
#define M_MAX_ERROR 255         /* maximum error message */

/* all messages 256 and greater are user defined for dialog controls etc. */

/* message structure */
struct two_shorts { short x,y;  };
union data_list
    {
    long long_data;
    void *ptr_data;
    struct two_shorts short_data;
    };
typedef struct
    {
    short id;               /* message id from list above or user defined */
    union data_list data;   /* message data can be a long, pointer or two shorts */
    } MESSAGE;

/* graphical objects */
#define OBJECT_NULL 0           /* object types */
#define OBJECT_MENU 1
#define OBJECT_POPUP 2
#define OBJECT_MESSAGEBOX 3
#define OBJECT_DIALOG 4
typedef struct object_list
    {
    short id;                   /* object type from defines above */
    void (*message_handler)(MESSAGE *,void *);  /* object message handler */
    void *data;                 /* pointer to object data */
    fg_box_t screen;            /* object screen extent */
    fg_handle_t save_area;      /* handle of area saved under object */
    struct object_list *next;   /* next object in list or NULL */
    } GOB;
typedef void (*GENERIC_MESSAGE_HANDLER)(MESSAGE *message,void *);


/* global data */
extern short gui_errno;         /* last error message */
#ifndef GUI_SOURCE
extern const short gui_screen_width,gui_screen_height;  /* gui screen dimensions */
extern const short gui_char_width,gui_char_height;      /* gui text cell dimensions */
#endif

/* prototypes */
short gui_open(void);           /* must be called before using gui */
void gui_close(void);           /* called after finished with gui */
short object_add(short id,void (*message_handler)(MESSAGE *message,void *data),void *data,fg_pbox_t screen);    /* add object to active list */
short object_remove(void *data);        /* removes object from active list */
GOB *object_exists(void *data);         /* returns pointer to object or NULL if none */
short message_get(MESSAGE *message);    /* gets next message from input devices or system */
void message_send(MESSAGE *message);    /* send a message down the list */
short message_send_object(MESSAGE *message,void *data); /* send a message to a particular object */
short message_box(char *str);   /* puts a message box on the screen */
short error_box(short id);      /* displays a box for errors */
short yn_box(char *str);        /* displays a message box and waits for y/n response */
short exclusive_focus_set(void *data);  /* sets focus to a particular object */
short exclusive_focus_clear(void *data);/* clears focus restriction */
void input_handler_set_default(void (*message_handler)(MESSAGE *message));  /* message handler to be invoked when no other objects want message */
void screen_clear(void);        /* clears screen to system background color */



/* --------- MENU.C, MENUS AND POPUPS --------- */

/* sizes */
#define MENU_MAX_ITEMS 64
#define POPUP_MAX_ITEMS 64

/* popup submenus */
typedef struct popup_item
    {
    short id;               /* associated message id */
    char *name;             /* name of item, note: use of '&' will highlight next character */
    short accelerator;      /* accelerator key or 0 if none */
    unsigned short status;  /* see status defines below */
    /* end of initialized data */
    fg_box_t screen;        /* hotspot on screen, filled in when menu is opened */
    struct popup_item *next;/* pointer to next item in list or NULL if end, filled in when menu is opened */
    } POPUP_ITEM;


/* menu status */
#define MENU_ACTIVE 1
#define MENU_GRAY 2
#define MENU_HIDDEN 4
#define MENU_STATUS_MASK (MENU_ACTIVE | MENU_GRAY | MENU_HIDDEN)
#define MENU_SELECTED 8
#define MENU_BITS 0x000f

/* menu bars are linked lists of this struct */
typedef struct menu_item
    {
    short id;               /* associated message id */
    char *name;             /* name of item, note: use of '&' will highlight next character */
    short accelerator;      /* accelerator key or 0 if none */
    POPUP_ITEM *popup;      /* pop up associated with menu item, or NULL if none */
    short number_of_popup_items;    /* number of items in associated popup or 0 if none */
    unsigned short status;  /* see status defines above */
    /* end of initialized data */
    fg_box_t screen;        /* hotspot on screen, filled in when menu is opened */
    struct menu_item *next; /* pointer to next item in list or NULL if end, filled in when menu is opened */
    } MENU_ITEM;

/* menu prototypes */
short menu_open(MENU_ITEM menubar[],short number_of_items);     /* draws a menubar */
void menu_message_handler(MESSAGE *message,MENU_ITEM *menu);    /* handles messages for menus */
short menu_close(MENU_ITEM menubar[]);                          /* erases a menubar */
short menu_modify(MENU_ITEM menubar[],short menu_id,unsigned short status); /* modifies the status of a menu item, ACTIVE, GRAY or HIDDEN */
short menu_clear(MENU_ITEM menubar[]);                          /* clear any open popups */
short popup_open(POPUP_ITEM popup[],short number_of_items,short x,short y);     /* draws a popup */
void popup_message_handler(MESSAGE *message,POPUP_ITEM *popup); /* handles messages for popups */
short popup_close(POPUP_ITEM popup[]);                          /* erases a popup */
short popup_modify(POPUP_ITEM popup[],short popup_id,unsigned short status);/* modifies the status of a popup item, ACTIVE, GRAY or HIDDEN */



/* --------- DIALOG.C, DIALOG BOXES --------- */

/* sizes */
#define DIALOG_MAX_ITEMS 256

/* measurement units of a dialog box are in quarter text cells */
#define DIALOG_UNITS 4

/* dialog types */
#define DIALOG_MIN_TYPE 1
#define DIALOG_TEXT 1
#define DIALOG_BUTTON 2
#define DIALOG_RADIOBUTTON 3
#define DIALOG_CHECKBOX 4
#define DIALOG_LISTBOX 5
#define DIALOG_EDITBOX 6
#define DIALOG_MAX_TYPE 6

/* DIALOG_ITEM state */
#define DIALOG_ALLOCATED 1      /* dialog memory state */
#define DIALOG_FIXED 2
#define DIALOG_FOCUS_SKIP 4     /* dialog focus state */
#define DIALOG_FOCUS_HERE 8

/* dialog object status */
#define DIALOG_ACTIVE 1
#define DIALOG_INACTIVE 2
#define DIALOG_ACTIVE_MASK (DIALOG_ACTIVE | DIALOG_INACTIVE)
#define DIALOG_SELECTED 4
#define DIALOG_GRAY_BIT 8
#define DIALOG_GRAY (DIALOG_GRAY_BIT | DIALOG_INACTIVE)
#define DIALOG_COMPLETED 16
#define DIALOG_OPENED 32
#define DIALOG_BITS 0x003f

/* dialog structure, one for each item or collection of items in the dialog box */
typedef struct dialog_item
    {
    short type;                 /* dialog type from defines above */
    void *data;                 /* dialog data */
    /* end of initialized data */
    unsigned short dialog_state;/* memory and focus state of dialog */
    fg_box_t focus;             /* box drawn when focusing in dialog */
    struct dialog_item *next;   /* next dialog item in the linked list */
    } DIALOG_ITEM;

/** DIALOG TEXT STRUCTURE **/
typedef struct
    {
    char *name;         /* character string of text */
    short loc_x,loc_y;  /* location of text relative to dialog box lower left corner, values are in units of quarter text cells */
    unsigned short status;  /* text status from defines above */
    /* end of initialized data */
    } TEXT;

/** DIALOG BUTTON STRUCTURE **/
typedef struct
    {
    short id;               /* associated message id */
    char *name;             /* name on button */
    short accelerator;      /* accelerator key or 0 if none */
    short loc_x,loc_y;      /* location of button relative to dialog box lower left corner, values are in units of quarter text cells */
    unsigned short status;  /* button status from defines above */
    /* end of initialized data */
    fg_box_t screen;        /* button hotspot in screen coordinates, filled when dialog is opened */
    } BUTTON;

/** DIALOG RADIO BUTTON STRUCTURE **/
typedef struct
    {
    short id;                   /* id of radio button set */
    short number_of_buttons;    /* number of buttons in radio collection */
    BUTTON *buttons;            /* array of buttons in radio collection */
    unsigned short status;      /* radio button status from defines above */
    /* end of initialized data */
    DIALOG_ITEM *dialog;        /* parent dialog */
    } RADIOBUTTON;

/** DIALOG LISTBOX STRUCTURE **/
/* allocation sizes and allocation sequencing */
#define LISTBOX_MEM_PAGE_SIZE 64
#define LISTBOX_FIRST_PAGE 0
#define LISTBOX_SUCCEEDING_PAGES 1
/* listbox displayed characters */
#define LIST_UPARROW 24
#define LIST_DOWNARROW 25
#define LIST_RIGHTARROW 16
typedef struct listbox_page
    {
    char *listbox_items;                /* data for listbox */
    short number_of_items;              /* number of items in listbox */
    struct listbox_page *previous_page; /* previous page in doubly linked list of pages */
    struct listbox_page *next_page;     /* next page in doubly linked list of pages */
    } LISTBOX_PAGE;
typedef struct
    {
    short id;               /* associated message id */
    short loc_x,loc_y;      /* location of listbox relative to dialog box lower left corner, values are in units of quarter text cells */
    short width,height;     /* listbox dimensions in quarter text cells, the displayed listbox will be rounded down in full text cells */
    short (*first_item)(char *str);     /* function which returns first item in listbox or NULL if none */
    short (*next_item)(char *str);      /* function which returns next item in listbox or NULL if none */
    unsigned short status;  /* whether or not list box is active, see dialog status defines above */
    /* end of initialized data */
    fg_box_t screen;        /* listbox hotspot in screen coordinates, filled when dialog is opened */
    fg_box_t marker;        /* hotspots for marker area */
    fg_box_t listbox;       /* hotspots for list area */
    fg_box_t up;            /* up arrow hotspots */
    fg_box_t down;          /* down arrow hotspots */
    LISTBOX_PAGE *first_page;   /* pointer to start of linked list of pages in listbox */
    LISTBOX_PAGE *current_page; /* pointer to current page in list of pages */
    short page_offset;          /* offset in current page for first item on screen */
    short screen_offset;        /* offset on screen for current place marker */
    } LISTBOX;

/** DIALOG EDITBOX STRUCTURE **/
/* EDITBOX message modifiers */
#define EDITBOX_CHANGE 0            /* a change occurred in the editbox */
#define EDITBOX_ACCEPT 1            /* the RETURN key was pressed in the editbox */
/* special keys used in editbox */
#define EDITBOX_HOME HOME           /* move to start of edit */
#define EDITBOX_END END             /* move to end of edit */
#define EDITBOX_DELETE_EOL CTRLEND  /* delete to end of line */
#define isprint_ibm(c) ((c<256&&isprint(c))||((c)>=128&&(c)<=175)||((c)>=224&&(c)<=239))    /* ibm extended character set for foreign language characters only */
/* other editbox control keys are: LEFTARROW,RIGHTARROW,INS,DELETE and BKSP */
/* editbox displayed characters */
#define EDITBOX_CURSOR_INSERT 22    /* cursor displayed when inserting */
#define EDITBOX_CURSOR_OVERWRITE '_'/* cursor displayed when overwriting */
typedef struct
    {
    short id;               /* associated message id */
    short loc_x,loc_y;      /* location of editbox relative to dialog box lower left corner, values are in units of quarter text cells */
    short screen_width;     /* displayed editbox width in quarter text cells, the displayed editbox will be rounded down in full text cells */
    short edit_width;       /* width of editable string in FULL text cells.
                             * If this is greater than the screen_width, the text is scrolled.
                             * Note storage space in edit_string must be edit_width+1
                             * The screen width should never be greater than the
                             * edit width */
    char *edit_string;      /* storage for string in editbox */
    unsigned short status;  /* whether or not edit box is active, see dialog status defines above */
    /* end of initialized data */
    fg_box_t screen;        /* editbox hotspot in screen coordinates, filled when dialog is opened */
    short curtype,curpos,xpos,scroll_offset,insert; /* editbox static data */
    } EDITBOX;

/** DIALOG PROTOTYPES **/
short dialog_open(DIALOG_ITEM dialog[],short number_of_items,short loc_x,short loc_y,short width,short height);     /* draws a dialog box */
void dialog_message_handler(MESSAGE *message,DIALOG_ITEM *dialog);  /* handles dialog box messages */
short dialog_close(DIALOG_ITEM dialog[]);                           /* erases a dialog box */
short dialog_add_item(short type,void *data,DIALOG_ITEM dialog[]);  /* add an item to an open dialog */
short editbox_initialize(EDITBOX *edit);                            /* initialize an editbox with a new string */
short listbox_initialize(LISTBOX *list);                            /* initialize a listbox with a new list */
short radiobutton_set(RADIOBUTTON *radio,short id);                 /* sets a particular radiobutton */
short checkbox_set(BUTTON *button,short id);                        /* sets a checkbox */
short checkbox_clear(BUTTON *button,short id);                      /* clears a checkbox */

/** DIALOG MACROS **/
/* change the status of a dialog item to DIALOG_ACTIVE or DIALOG_INACTIVE, this should not be done while the dialog is displayed */
#define dialog_status_set(dialog,newstat) ((dialog).status = ((dialog).status & ~DIALOG_ACTIVE_MASK) | ((newstat) & DIALOG_ACTIVE_MASK))
#define is_active(dialog) ((dialog).status & DIALOG_ACTIVE)
#define is_inactive(dialog) (((dialog).status & DIALOG_ACTIVE) == 0)
#define is_selected(dialog) ((dialog).status & DIALOG_SELECTED)
#define is_gray(dialog) ((dialog).status & DIALOG_GRAY_BIT)




#endif  /* _GUI */
