
#ifndef _TESTOBJ_H_
#define _TESTOBJ_H_

#define TIMERDECL	int startHi; \
					int startLo; \
					int endHi; \
					int endLo;
// opcodes for RDTSC
#define TIMERSTART 	_asm _emit 0Fh \
					_asm _emit 31h \
					_asm mov startHi, edx \
					_asm mov startLo, eax
// opcodes for RDTSC
#define TIMERSTOP	_asm _emit 0Fh \
					_asm _emit 31h \
					_asm mov endHi, edx \
					_asm mov endLo, eax

class CMemBlock : public CObject
{
protected:
	DECLARE_DYNCREATE(CMemBlock)

public:

	CMemBlock();
	~CMemBlock();

	LPVOID Allocate(DWORD dwSize);
	void Allocate(float** ppFloat, DWORD dwFloatCount);
	void Allocate(short** ppShort, DWORD dwShortCount);
	void Allocate(int** ppInt, DWORD dwIntCount);
	void Allocate(UCHAR** ppUChar, DWORD dwCharCount);
	void Allocate(double** ppDouble, DWORD dwDoubleCount);
	void ZeroBuffer();

	//Should be protected, but quick & dirty for now
	DWORD m_dwSize; 
	LPVOID m_ptr; // Aligned pointer

protected:

	LPVOID m_ptrRaw; // Actual pointer
};

/////////////////////////////////////////////////////////////////////////////
class CTestObject : public CObject
{
protected:
DECLARE_DYNCREATE(CTestObject)

public:

	CTestObject();
	CTestObject(UINT nTestType){ 
		CTestObject::CTestObject(); m_TestType = nTestType; 
		}
	~CTestObject();

	BOOL m_bMMXPresent;
	BOOL m_bColdCache;
	UINT m_TestType;
	DWORD m_dwCount;
	CListBox *m_pOutBox;

	// Run various Tests
	virtual void RunTest();

protected:

	// Timer vars
	int m_startHi;
	int m_startLo;
	int m_endHi;
	int m_endLo;

	// Result Structures
	enum eResultSettings{
		RESULT_TIME		= 0x00000001,	
		RESULT_OVERHEAD = 0x00000002,
		RESULT_DIFF		= 0x00000004
	};

	typedef struct _TESTSTRUCT
	{	
		DWORD dwFlags;
		int time;		// Number of cycles taken
		float diff;		// Difference between this and C results (should be 0)
	} TESTSTRUCT, *PTESTSTRUCT;

	TESTSTRUCT m_tC;
	TESTSTRUCT m_tPent;
	TESTSTRUCT m_tMMX;

	// Various pointers just declared here for convenience
	CMemBlock m_MBC1, m_MBC2, m_MBC3;
	CMemBlock m_MBP1, m_MBP2, m_MBP3;
	CMemBlock m_MBM1, m_MBM2, m_MBM3;

	// For C calls
	unsigned char	*m_pucC1,	*m_pucC2,	*m_pucC3;
	float			*m_pfC1,	*m_pfC2,	*m_pfC3;
	double			*m_pdC1,	*m_pdC2,	*m_pdC3;
	short			*m_psC1,	*m_psC2,	*m_psC3;
	int				*m_piC1,	*m_piC2,	*m_piC3;

	// For Pentium calls
	unsigned char	*m_pucP1,	*m_pucP2,	*m_pucP3;
	float			*m_pfP1,	*m_pfP2,	*m_pfP3;
	double			*m_pdP1,	*m_pdP2,	*m_pdP3;
	short			*m_psP1,	*m_psP2,	*m_psP3;
	int				*m_piP1,	*m_piP2,	*m_piP3;

	// For Pentium MMX calls
	unsigned char	*m_pucM1,	*m_pucM2,	*m_pucM3;
	float			*m_pfM1,	*m_pfM2,	*m_pfM3;
	double			*m_pdM1,	*m_pdM2,	*m_pdM3;
	short			*m_psM1,	*m_psM2,	*m_psM3;
	int				*m_piM1,	*m_piM2,	*m_piM3;

	// Setup
	virtual void ZeroAllBuffers();
	virtual void ChillCache();
	virtual void HeatCache(LPVOID pBuf, int count);

	// Tests
	virtual void RunC(){return;};
	virtual void RunPent(){return;};
	virtual void RunMMX(){return;};

	// Calculate the cumulative difference between two buffers
	virtual float CompareBuffers(float*,float*,DWORD dwCount);
	virtual float CompareBuffers(int*,int*,DWORD dwCount);
	virtual float CompareBuffers(short*,short*, DWORD dwCount);
	virtual float CompareBuffers(double*,double*, DWORD dwCount);
	virtual float CompareBuffers(PUCHAR, PUCHAR, DWORD dwCount);
	
	// Output the results
	virtual void ShowResults(LPCTSTR sTestName, BOOL bShowCycles=FALSE);

};

#endif //_TESTOBJ_H_