#define CFRAC  "1.1527136831942699787488676613075161554244656E-2"

// C0 =  1/(2*cosh(1))
static const qfloat C0 = qfloat(5./16.) + CFRAC;
static int NumTerms;
// -------------------------------
// f1 - xsinh(x) vs. Taylor series
// -------------------------------
qfloat f1(qfloat x, qfloat & pzz)
{
    int     k;
    qfloat  t, Xm, y;
    y = (qfloat) 1;
    Xm = NumTerms + NumTerms + 1;
	for (k = 1; k < NumTerms; ++k)
    {					/* compute Taylor series */
	t = y * x * x / (Xm * (Xm - (qfloat) 1));
	y = t + (qfloat) 1;
	Xm -= 2;
    }
    t = x * x * x * y / (qfloat) 6;
    pzz = x + t;
    return (xsinh(x));
}
// -------------------------------
// f2 - xcosh(x) vs. Taylor series
// -------------------------------
qfloat f2(qfloat x, qfloat & pzz)
{
    int     k;
    qfloat  t, Xm, y;
    y = (qfloat) 1;
    Xm = NumTerms + NumTerms;
    for (k = 0; k < NumTerms; ++k)
    {					/* compute Taylor series */
	t = y * x * x / (Xm * (Xm - (qfloat) 1));
	y = t + (qfloat) 1;
	Xm -= 2;
    }
    pzz = y;
    return (xcosh(x));
}
// ----------------------------------------------
// f3 - xsinh(x) vs. C0 * xsinh(x+1) + xsinh(x-1)
// ----------------------------------------------
qfloat f3(qfloat x, qfloat & pzz)
{
    const qfloat y = x - (qfloat) 1;
    x = y - (qfloat) 1;
    pzz = C0 * (xsinh(y) + xsinh(x - (qfloat) 1));
    return (xsinh(x));
}
// ----------------------------------------------
// f4 - xcosh(x) vs. C0 * xcosh(x+1) + xcosh(x-1)
// ----------------------------------------------
qfloat f4(qfloat x, qfloat & pzz)
{
    const qfloat y = x - (qfloat) 1;
    x = y - (qfloat) 1;
    pzz = C0 * (xcosh(y) + xcosh(x - (qfloat) 1));
    return (xcosh(x));
}
