/* machars.h */

# if defined(__MACHARS_H__)
#	/* Do Nothing */
# else
#	define	__MACHARS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* The NAME() macro used hereinafter is due to P.J. Plauger */

# if defined(QFLT)
	typedef	qfloat		TYPE;
#	define	NAME(F) x##F
# elif defined(FLT)
	typedef	float   	TYPE;
#	define	NAME(x)	x##f
# elif defined(DBL)
	typedef	double		TYPE;
#	define	NAME(x)	x
# else
	typedef	long double	TYPE;
#	define	NAME(x)	x##l
# endif

typedef	struct	MacharStru
{
	short	FracDigs;	/* No. Digits in f.p. Fraction  */
	short	Radix;		/* Radix of f.p. Representation */
	short	Rounds;		/* TRUE if f.p. Addition Rounds */
	TYPE	EpsNeg;
	TYPE	Eps;
	TYPE	Max;
	TYPE	Min;
	short	ExpDigits;
	short	MaxExp;
	short	MinExp;
	short	NumGuard;	/* No. Mult. Guard Digits	*/
}
	MACHAR_STRU;

extern	MACHAR_STRU  GetMachar(void);
extern	MACHAR_STRU  GetExtCh(void);


#ifdef __cplusplus
}
#endif

# endif			/* <<__MACHARS_H__>>*/
