/*							qcbrt.c 	*/

/* cube root */
/* 21 December 83, SLM */

#include "qhead.h"
extern QELT qzero[], qone[], qtwo[], qthree[];

#ifndef ANSIPROT
double	cbrt();
#endif

int
qcbrt(xx, y)
QELT   *xx, *y;
{
    QELT    a[NQ], b[NQ], c[NQ];
    int     sign;

    qmov(xx, c);
    sign = c[0];
    c[0] = 0;

    if (xx[1] == 0)
    {
	qclear(a);
    }
    else
    {
	qlog(c, b);
	qdiv(qthree, b, b);
	qexp(b, a);

	if (xx[1] >= 2)
	{
	    qmul(a, a, b);		/* x * x	   */
	    qdiv(b, c, b);		/* z / x*x */
	    qsub(b, a, b);		/* x - z/x*x	   */
	    qdiv(qthree, b, b);		/* .../3	   */
	    qsub(b, a, a);		/* x - ...	   */
	}
    }
    if (sign != 0)
	a[0] = (QELT) - 1;

    qmov(a, y);
    return(0);
}
