/* ====== */
/* xvyn.h */
/* ====== */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN   	xyn
#define TST_FUN_0  NAME(_y0)
// --------------------------|
// TST_FUN_0(x) vs. ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)(xtold(x));

    pzz = EXT_FUN(0, FunArg);

    return TST_FUN_0(FunArg);
}
#define TST_FUN_1  NAME(_y1)
// --------------------------|
// TST_FUN_1(x) vs. ExtFun(x)|
// --------------------------|
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)(xtold(x));

    pzz = EXT_FUN(1, FunArg);

    return TST_FUN_1(FunArg);
}
/* -------------------- */
/* First 20 zeros of Y0 */
/* -------------------- */
static double  Y0Zeros[] =
    {
	  0.8935770,  3.9576784,  7.0860511, 10.2223431,
	 13.3610970, 16.5009223, 19.6413096, 22.7820280,
	 25.9229576, 29.0640302, 32.2052041, 35.3464523,
	 38.4877567, 41.6291045, 44.7704866, 47.9118963,
	 51.0533286, 54.1947794, 57.3362457, 60.4777252
    };
static	const	int	NumY0Zeros =
	(sizeof(Y0Zeros) / sizeof(*Y0Zeros));

/* -------------------- */
/* First 20 zeros of Y1 */
/* -------------------- */
static double  Y1Zeros[] =
    {
          2.1971413,  5.4296810,  8.5960059, 11.7491560,
         14.8974425, 18.0434024, 21.1880690, 24.3319426,
         27.4752950, 30.6182865, 33.7610178, 36.9035553,
         40.0459446, 43.1882181, 46.3303993, 49.4725057,
         52.6145508, 55.7565449, 58.8984962, 62.0404111
    };
static	const	int	NumY1Zeros =
	(sizeof(Y1Zeros) / sizeof(*Y1Zeros));

/* ==================================================================== */
/* main - Compares library functions yn with extended version in qyn.c	*/
/* ==================================================================== */
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    const
    char	*FunStr1 = MAK_STR(TST_FUN_0),
    		*FunStr2 = MAK_STR(TST_FUN_1);
    char	 Label[128];
    int		 k;
    TYPE	 TestArg, TestAns;
    qfloat	 HiLim, LoLim;
    MACHAR_STRU  MachData;

    printf("Test of %s(x) vs. %s(x):\n", FunStr1, EXT_FUN_STR);
    MachData = GetMachar();

    printf("There are %d Base %d Significant Digits\n",
	MachData.FracDigs, MachData.Radix);

    LoLim = 1;
    HiLim = 3;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 1,
	FunStr1, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 4.25;
    HiLim = 7;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 2,
	FunStr1, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 11;
    HiLim = 13;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 3,
	FunStr1, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 0;
    HiLim = 2;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 4,
	FunStr2, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);
    fflush(NULL);

    LoLim = 6;
    HiLim = 8;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 5,
	FunStr2, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    LoLim = 12;
    HiLim = 14;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 6,
	FunStr2, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    fflush(NULL);
    printf("\nSPECIAL VALUES:\n");

    printf("\nTesting zeros of %s\n", FunStr1);

    printf("\nZero #\t   %s(z)\t\t%s(0, z)"
		"\t    Absolute Error\n",
		FunStr1, EXT_FUN_STR);

    for (k = 0; k < NumY0Zeros; ++k)
    {
	qfloat  XTestAns, XAbsErr = 0;

	TestArg  = (TYPE)Y0Zeros[k];
	TestAns  = TST_FUN_0(TestArg);
	XTestAns = EXT_FUN(0, TestArg);
	XAbsErr  = xabs(XTestAns - TestAns);
        printf("%3d\t%+.10Le   %+.10Le   %.10Le\n",
		k+1,(LDBL)TestAns,
		xtold(XTestAns), xtold(XAbsErr));
    }

    printf("\nTesting zeros of %s\n", FunStr2);

    printf("\nZero #\t   %s(z)\t\t%s(1, z)"
		"\t    Absolute Error\n",
		FunStr1, EXT_FUN_STR);

    for (k = 0; k < NumY1Zeros; ++k)
    {
	qfloat  XTestAns, XAbsErr = 0;

	TestArg  = (TYPE)Y1Zeros[k];
	TestAns  = TST_FUN_1(TestArg);
	XTestAns = EXT_FUN(1, TestArg);
	XAbsErr  = xabs(XTestAns - TestAns);
        printf("%3d\t%+.10Le   %+.10Le   %.10Le\n",
		k+1,(LDBL)TestAns,
		xtold(XTestAns), xtold(XAbsErr));
    }

#define TST_FUN_N  NAME(_yn)
    printf("\nTesting the identity "
	   "z = 2Y1(z)/(Y0(z) + Y2(z)) for integral z\n");

    for (k = 1; k <= 10; ++k)
    {
	TYPE	Z;
	Z = 2*TST_FUN_1(k) /
		(TST_FUN_0(k) + TST_FUN_N(2, k));
# if defined(FLT)
	printf("\tz = %2d, F(z) = %.7G\n", k, Z);
# elif defined(DBL)
	printf("\tz = %2d, F(z) = %.16G\n", k, Z);
# else
	printf("\tz = %2d, F(z) = %.19LG\n", k, Z);
# endif
	fflush(NULL);
    }

    printf("\nTesting the identity "
	   "z = 10Y5(z)/(Y4(z) + Y6(z)) for integral z\n");

    for (k = 1; k <= 10; ++k)
    {
	TYPE	Z;
	Z = 10*TST_FUN_N(5, k) /
		(TST_FUN_N(4, k) + TST_FUN_N(6, k));
# if defined(FLT)
	printf("\t%z = %2d, F(z) = %.7G\n", k, Z);
# elif defined(DBL)
	printf("\t%z = %2d, F(z) = %.16G\n", k, Z);
# else
	printf("\t%z = %2d, F(z) = %.19LG\n", k, Z);
# endif
	fflush(NULL);
    }
    return (0);
}
