/* ======= */
/* xvtan.h */
/* ======= */
// After Cody & Waite and Plauger
#include "xverfun.h"
// ---------------------
// tan(x) versus xtan(x)
// ---------------------
static
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    TanArg;

    TanArg = (TYPE)xtold(x);

    pzz = xtan(TanArg);

    return NAME(tan)(TanArg);
}
// ---------------------
// cot(x) versus xcot(x)
// ---------------------
static
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    CotArg;

    CotArg = (TYPE)xtold(x);

    pzz = xcot(CotArg);

    return NAME(cot)(CotArg);
}
// -------------------------------------------------------------
// Main Program to Test tan/cot Function versus Extended tan/cot
// -------------------------------------------------------------
static const TYPE PI = 3.141592653589793238462643383279502884L;

#define	MAK_STR(x)	STR_NAME(x)
#define	STR_NAME(x)	#x
#define	TEST_FUN_1	NAME(tan)
#define	TEST_FUN_2	NAME(cot)
#define	TEST_SIZE	1000
int
main()
{
    int		 k;
    TYPE	 RadixPow;
    TYPE	 TanArg, TanAns;
    char	 Label[128];
    const char  *FunStr1 = MAK_STR(TEST_FUN_1);
    const char  *FunStr2 = MAK_STR(TEST_FUN_2);
    MACHAR_STRU  MachData;
    qfloat	 HiLim, LoLim, Pi;

    printf("Test of %s(x) vs. xtan(x) & "
	           "%s(x) vs. xcot(x):\n",
	    FunStr1, FunStr2);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    Pi    = 2 * xatan2(1, 0);
    LoLim = 0.0;
    HiLim = Pi / 4;

    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(0, pi/4)", FunStr1, TEST_SIZE);

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 0.875 * Pi;
    HiLim = 1.125 * Pi;
    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%s, %s)", FunStr1,
		TEST_SIZE, "0.875*pi", "1.125*pi");

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 6.00 * Pi;
    HiLim = 6.25 * Pi;
    sprintf(Label, "Test 3: %s(x) for %d values in "
		   "(%s, %s)", FunStr1,
		TEST_SIZE, "6.000*pi", "6.250*pi");

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);
# if defined(COTAN)
    sprintf(Label, "Test 4: %s(x) for %d values in "
		   "(%s, %s)", FunStr2,
		TEST_SIZE, "6.000*pi", "6.250*pi");

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);
# endif
    printf("\nSPECIAL VALUES:\n\n");

    printf("%s(x) + %s(-x) for random values in "
	   "[0, 6PI)\n", FunStr1, FunStr1);

    for (k = 1; k <= 5; ++k)
    {
	TanArg = (TYPE) (LDURand() * 6.0 * PI);
	TanAns = NAME(tan) (TanArg);
	TanAns += NAME(tan) (-TanArg);

	printf("\tx =%14.10Lf, %s(x) + %s(-x) = %.10LG\n",
	    (LDBL) TanArg, FunStr1, FunStr1,
	    (LDBL) TanAns);
    }

    RadixPow = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs; ++k)
	RadixPow *= (TYPE) MachData.Radix;

    RadixPow = (TYPE) (LDURand() / RadixPow);

    printf("\ntan(x) - x for Small x\n");
    for (k = 1; k <= 5; ++k)
    {
	TanAns = NAME(tan)(RadixPow) - RadixPow;
	printf("\tx = %.10LE, %s(x) - x = %.20LG\n",
	    (LDBL) RadixPow, FunStr1,
	    (LDBL) TanAns);

	RadixPow /= (TYPE) MachData.Radix;
    }

    TanArg = (TYPE) 1;
    for (k = 0; k < -3 * (MachData.MinExp / 4); ++k)
	TanArg /= (TYPE) MachData.Radix;

    TanAns = NAME(tan)(TanArg);

    printf("\n\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) TanArg, FunStr1,
	(LDBL) TanAns);
    {
	qfloat	BaseAns = xtan(11);
	qfloat  TestAns = (qfloat)NAME(tan)((TYPE)11);
	qfloat  RelErr  = (TestAns - BaseAns) / BaseAns;

	TYPE    ErrDigs;

	printf("\n\t%s(11) = %.20LG"
		"\n\trelative error = %.10LG\n",
	    FunStr1, xtold(TestAns), xtold(RelErr));

	ErrDigs = NAME(log) ((TYPE)xtold(xabs(RelErr))) /
		  NAME(log) ((TYPE) MachData.Radix);

        if ((ErrDigs += (TYPE) MachData.FracDigs) <= 0)
        {
	    ErrDigs = 0;
        }
        printf("\tEstimated Loss of Base %d "
		"Significant Digits is %.2Lf\n\n",
	MachData.Radix, (LDBL) ErrDigs);
    }

    printf("BOUNDARY VALUES:\n");

    TanArg = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs / 2; ++k)
	TanArg *= (TYPE) MachData.Radix;

    fflush(NULL);
    printf("\nThe next call should not "
	   "trigger an error message:\n");
    fflush(NULL);
    TanAns = NAME(tan) (TanArg);

    fflush(NULL);
    printf("\t%s(%.10LG) = %.10LG\n", FunStr1,
	   (LDBL) TanArg,
	   (LDBL) TanAns);

    TanArg = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs; ++k)
	TanArg *= (TYPE) MachData.Radix;

    printf("\nThe next calls might trigger "
	   "error messages:\n");
    fflush(NULL);
    TanAns = NAME(tan) (TanArg);

    fflush(NULL);
    printf("\t%s(%.10LG) = %.10LG\n", FunStr1,
	   (LDBL) TanArg,
	   (LDBL) TanAns);

    printf("\nAttempting to calculate "
	   "tan(x) for x very near pi/2\n");

    TanArg = (TYPE)(PI/2 * (1.0 - 2*MachData.EpsNeg));
    printf("PI/2   = %.20LG\n", (LDBL)((TYPE)PI/2));
    printf("TanArg = %.20LG\n", (LDBL)TanArg);
    printf("Diff:  = %.20LG\n", (LDBL)(PI/2 - TanArg));
    printf("\t%s(%.20LG) = ", FunStr1, (LDBL) TanArg);

    fflush(NULL);
    TanAns = NAME(tan)(TanArg);
    fflush(NULL);

    printf("%.10LG\n", (LDBL) TanAns);

    printf("\nAttempting to calculate "
	   "tan(x) for x at pi/2\n");

    TanArg = (TYPE)PI/2;
    printf("PI/2   = %.20LG\n", (LDBL)((TYPE)PI/2));
    printf("TanArg = %.20LG\n", (LDBL)TanArg);
    printf("Diff:  = %.20LG\n", (LDBL)(PI/2 - TanArg));
    printf("\t%s(%.20LG) = ", FunStr1, (LDBL) TanArg);

    fflush(NULL);
    TanAns = NAME(tan)(TanArg);
    fflush(NULL);

    printf("%.10LG\n", (LDBL) TanAns);

    return (0);
}
