/* ======= */
/* xvlog.h */
/* ======= */
// After Cody & Waite and Plauger
#include "xverfun.h"
// ---------------------
// log(x) versus xlog(x)
// ---------------------
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    LogArg;

    LogArg = (TYPE)xtold(x);

    pzz = xlog(LogArg);

    return NAME(log)(LogArg);
}
// -------------------------
// log10(x) versus xlog10(x)
// -------------------------
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    LogArg;

    LogArg = (TYPE)xtold(x);

    pzz = xlog10(LogArg);

    return NAME(log10)(LogArg);
}
// -------------------------
// 2*log(x) versus xlog(x*x)
// -------------------------
qfloat f3 (qfloat x, qfloat &pzz)
{
    TYPE    LogAns, LogArg;

    LogArg = (TYPE)xtold(x);

    pzz = xlog(LogArg*LogArg);

    LogAns = NAME(log)(LogArg);

    return (LogAns + LogAns);
}
// -----------------------------------------------------
// Main Program to Test Log Function versus Extended Log
// -----------------------------------------------------
#define	MAK_STR(x)	STR_NAME(x)
#define	STR_NAME(x)	#x
#define	TEST_FUN_1	NAME(log)
#define	TEST_FUN_2	NAME(log10)
#define	TEST_SIZE	1000
int
main()
{
    int		 k;
    TYPE	 ArgDelt;
    TYPE	 LogAns;
    char	 Label[128], Number[32];
    const char  *FunStr1 = MAK_STR(TEST_FUN_1);
    const char  *FunStr2 = MAK_STR(TEST_FUN_2);
    MACHAR_STRU  MachData;
    qfloat	 LoLim, HiLim, Arg1, Result;

    printf("Test of %s(x) vs. xlog(x):\n", FunStr1);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    ArgDelt = 1.0;

    for (k = 1; k <= MachData.FracDigs/3; ++k)
    {
	ArgDelt /= MachData.Radix;
    }

    HiLim = 1.0;
    LoLim = HiLim - ArgDelt;
    HiLim += ArgDelt;

    Arg1 = ArgDelt;
    qtoasc(&Arg1, Number, 2);

    sprintf(Label, "Test 1: %s(x) for values in "
	"(1-%s, 1+%s)", FunStr1, Number+1, Number+1);
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = xsqrt(0.5);
    HiLim = 15.0/16.0;
    sprintf(Label,
	"Test 2: %s(x) for values in (sqrt(0.5), 15/16)",
	FunStr1);
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    HiLim = xsqrt(10.0);
    LoLim = 1.0 / HiLim;
    HiLim = (qfloat)9.0 / (qfloat)10.0;
    sprintf(Label,
	"Test 3: %s(x) for values in (sqrt(0.1), 0.9)",
	FunStr2);
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    HiLim = 240.0;
    LoLim =  16.0;
    sprintf(Label,
	"Test 4: %s(x) for values in (16, 240)", FunStr1);
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f3, Label);

    printf("SPECIAL VALUES:\n\n");
    printf("Testing identity %s(x) = -%s(1/x)\n",
	FunStr1, FunStr1);
    for (k = 1; k <= 5; ++k)
    {
	TYPE	LogArg1, LogArg2;

	LogArg1 = (TYPE)LDURand();
	LogArg1 += LogArg1 + (TYPE)15.0;
	LogArg2 = (TYPE)1.0/LogArg1;
	LogAns =
	    NAME(log)((TYPE)LogArg1) + NAME(log)(LogArg2);

	printf("\tx = %.10Lf, %s(x) + %s(1/x) = %+.25LG\n",
		(LDBL) LogArg1, FunStr1,
		FunStr1, (LDBL) LogAns);
    }
    fflush(NULL);
    printf("\n\t%s(1) = %.25LG\n", FunStr1,
	(LDBL) NAME(log)((TYPE)1.0));

    printf("\nBOUNDARY VALUES:\n");
    printf("\nThe following calls should "
	   "not trigger error messages:\n\n");
    fflush(NULL);
    LogAns = NAME(log)(MachData.Min);
    printf("\t%s(%.10LG) = %+.10LG\n", FunStr1,
	(LDBL) MachData.Min, (LDBL) LogAns);

    fflush(NULL);
    LogAns = NAME(log)(MachData.Max);
    printf("\t%s(%.10LG) = %+.10LG\n", FunStr1,
	(LDBL) MachData.Max, (LDBL) LogAns);

    fflush(NULL);
    printf("\nThe following calls might "
	   "trigger error messages\n");
    fflush(NULL);
    LogAns = NAME(log)((TYPE)-2);
    fflush(NULL);
    printf("\t%s(-2) = %.10LG\n", FunStr1,
	(LDBL) LogAns);

    fflush(NULL);
    LogAns = NAME(log)((TYPE)0);
    fflush(NULL);
    printf("\t%s(0) = %.10LG\n", FunStr1,
	(LDBL) LogAns);

    return (0);
}
