/* ========= */
/* xvatanh.h */
/* ========= */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN 	xatanh
#define TST_FUN 	NAME(atanh)
// --------------------------|
// TstFun(x) versus ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)xtold(x);

    pzz = xatanh(FunArg);

    return NAME(atanh)(FunArg);
}
// ---------------------------------------------------------
// Main Program to Test atanh Function versus Extended atanh
// ---------------------------------------------------------
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    int 	    k;
    TYPE	    RadixPow;
    TYPE	    AtanhAns, AtanhArg;
    char	    Label[128];
    const char	   *FunStr = MAK_STR(NAME(atanh));
    MACHAR_STRU     MachData;
    qfloat	    HiLim, LoLim;

    printf("Test of %s(x) vs. %s(x):\n", FunStr, EXT_FUN_STR);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    LoLim = 0;
    HiLim = 0.5;

    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 0.5;
    HiLim = 1.0;

    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    printf("SPECIAL VALUES:\n");
    printf("\nThe following calls should "
	   "not trigger error messages:\n");

    printf("\n    Testing %s(x) vs. %s(-x) for "
	   "random Values in [0, 1)\n",
	   FunStr, FunStr);

    for (k = 1; k <= 5; ++k)
    {
	TYPE	AtanhArg1, AtanhArg2;

	AtanhArg1 = (TYPE)LDURand();
	AtanhArg2 = -AtanhArg1;
	AtanhAns  = NAME(atanh)(AtanhArg1) + NAME(atanh)(AtanhArg2);

	printf("\tx = %.10Lf, %s(x) + %s(-x) = %+.25LG\n",
		(LDBL)AtanhArg1, FunStr,
		FunStr, (LDBL) AtanhAns);
    }
    fflush(NULL);

    RadixPow = (TYPE)1;
    for (k = 1; k <= (MachData.FracDigs)/2; ++k)
	RadixPow *= (TYPE)MachData.Radix;

    AtanhArg = (TYPE) (LDURand() / RadixPow);

    printf("\n    Testing %s(x) - x for small values of x\n" ,
	   FunStr);
    for (k = 0; k < 5; ++k)
    {
	AtanhArg /= (TYPE) MachData.Radix;
	AtanhAns = NAME(atanh)(AtanhArg) - AtanhArg;
	printf("\tx = %.10LG, %s(x) - x = %.10LG\n",
	    (LDBL) AtanhArg, FunStr, (LDBL) AtanhAns);
    }

    printf("\n    Testing underflow in %s(x) "
	   "for very small x:\n", FunStr);

    AtanhArg = (TYPE) 1;
    for (k = 1; k <= -3 * (MachData.MinExp / 4); ++k)
	AtanhArg /= (TYPE) MachData.Radix;

    AtanhAns = NAME(atanh)(AtanhArg);

    fflush(NULL);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanhArg, FunStr, (LDBL) AtanhAns);
    fflush(NULL);

    printf("\nBOUNDARY VALUES:\n");

    printf("    Testing %s(x) for x = minimum "
	   "floating point value\n", FunStr);

    AtanhArg = MachData.Min;
    AtanhAns = NAME(atanh)(AtanhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanhArg, FunStr, (LDBL) AtanhAns);

    printf("\tTesting %s(x) for x = 0\n", FunStr);

    AtanhArg = 0;
    AtanhAns = NAME(atanh)(AtanhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanhArg, FunStr, (LDBL) AtanhAns);


    printf("\tTesting %s(x) for x = 1\n", FunStr);
    AtanhArg = (TYPE) 1;
    AtanhAns = NAME(atanh)(AtanhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanhArg, FunStr, (LDBL) AtanhAns);

    printf("    Testing %s(x) for x = -1\n", FunStr);
    AtanhArg = (TYPE) -1;
    AtanhAns = NAME(atanh)(AtanhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanhArg, FunStr, (LDBL) AtanhAns);

    printf("\nThe following call might "
	   "trigger an error message:\n");

    printf("    Testing %s(x) for x = maximum "
	   "floating point value\n", FunStr);
    AtanhArg = MachData.Max;
    AtanhAns = NAME(atanh)(AtanhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanhArg, FunStr, (LDBL) AtanhAns);
    return (0);
}
