/* ========= */
/* xvasinh.h */
/* ========= */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN 	xasinh
#define TST_FUN 	NAME(asinh)
// --------------------------|
// TstFun(x) versus ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)xtold(x);

    pzz = xasinh(FunArg);

    return NAME(asinh)(FunArg);
}
// ---------------------------------------------------------
// Main Program to Test asinh Function versus Extended asinh
// ---------------------------------------------------------
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    int 	    k;
    TYPE	    RadixPow;
    TYPE	    AsinhAns, AsinhArg;
    char	    Label[128];
    const char	   *FunStr = MAK_STR(NAME(asinh));
    MACHAR_STRU     MachData;
    qfloat	    HiLim, LoLim;

    printf("Test of %s(x) vs. %s(x):\n", FunStr, EXT_FUN_STR);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    LoLim = 0;
    HiLim = 0.5;

    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 0.5;
    HiLim = 1.0;

    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 10.;
    HiLim = 1.0E10;

    sprintf(Label, "Test 3: %s(x) for %d values in "
		   "(%+.5LG, %+.5LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 1.0E10;
    HiLim = 1.0E11;

    sprintf(Label, "Test 4: %s(x) for %d values in "
		   "(%+.5LG, %+.5LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    printf("SPECIAL VALUES:\n");
    printf("\nThe following calls should "
	   "not trigger error messages:\n");

    printf("\n\tTesting %s(x) vs. %s(-x) for "
	   "random Values in [0, 1)\n",
	   FunStr, FunStr);

    for (k = 1; k <= 5; ++k)
    {
	TYPE	AsinhArg1, AsinhArg2;

	AsinhArg1 = (TYPE)LDURand();
	AsinhArg2 = -AsinhArg1;
	AsinhAns  = NAME(asinh)(AsinhArg1) + NAME(asinh)(AsinhArg2);

	printf("\t\tx = %.10Lf, %s(x) + %s(-x) = %+.25LG\n",
		(LDBL)AsinhArg1, FunStr,
		FunStr, (LDBL) AsinhAns);
    }
    fflush(NULL);

    RadixPow = (TYPE)1;
    for (k = 1; k <= (MachData.FracDigs-1)/2; ++k)
	RadixPow *= (TYPE)MachData.Radix;

    AsinhArg = (TYPE) (LDURand() / RadixPow);

    printf("\n\tTesting %s(x) - x for small values of x\n" ,
	   FunStr);
    for (k = 0; k < 5; ++k)
    {
	AsinhArg /= (TYPE) MachData.Radix;
	AsinhAns = NAME(asinh)(AsinhArg) - AsinhArg;
	printf("\t\tx = %.10LG, %s(x) - x = %.10LG\n",
	    (LDBL) AsinhArg, FunStr, (LDBL) AsinhAns);
    }

    printf("\n\tTesting underflow in %s(x) "
	   "for very small x:\n", FunStr);

    AsinhArg = (TYPE) 1;
    for (k = 1; k <= -3 * (MachData.MinExp / 4); ++k)
	AsinhArg /= (TYPE) MachData.Radix;

    AsinhAns = NAME(asinh)(AsinhArg);

    fflush(NULL);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AsinhArg, FunStr, (LDBL) AsinhAns);
    fflush(NULL);

    printf("\nBOUNDARY VALUES:\n");

    printf("\tTesting %s(x) for x = maximum "
	   "floating point value\n", FunStr);
    AsinhArg = MachData.Max;
    AsinhAns = NAME(asinh)(AsinhArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AsinhArg, FunStr, (LDBL) AsinhAns);

    printf("\tTesting %s(x) for x = minimum "
	   "floating point value\n", FunStr);

    AsinhArg = MachData.Min;
    AsinhAns = NAME(asinh)(AsinhArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AsinhArg, FunStr, (LDBL) AsinhAns);

    printf("\tTesting %s(x) for x = 0\n", FunStr);

    AsinhArg = 0;
    AsinhAns = NAME(asinh)(AsinhArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AsinhArg, FunStr, (LDBL) AsinhAns);

    return (0);
}
