/* ============ */
/* getmachx.h	*/
/* ============ */
# if defined(__GETMACHX_H__)
#	/* Do Nothing */
# else
#	define	__GETMACHX_H__
#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include "machars.h"
/* Get machine characteristics - after P.J. Plauger's elefunt */
/* ==================================================================== */
/* GetMachar - Determines Computer's Floating-Point Characteristics     */
/* ==================================================================== */
MACHAR_STRU
GetMachar(void)
{
    short        k, n;
    const
    TYPE	 Zero = 0, One = 1;
    TYPE         T0, T1, T2;
    MACHAR_STRU  MachData;

    /* --------------- */
    /* Determine Radix */
    /* --------------- */

    MachData.Radix = FLT_RADIX;

    /* -------------------------------- */
    /* Determine No. Digits in Fraction */
    /* -------------------------------- */
#   if defined(FLT)
	MachData.FracDigs = FLT_MANT_DIG;
#   elif defined(DBL)
	MachData.FracDigs = DBL_MANT_DIG;
#   else
	MachData.FracDigs = LDBL_MANT_DIG;
#   endif

    /* -------------------------------- */
    /* Determine Whether Floating Point */
    /* Addition Chops (0) or Rounds (1) */
    /* -------------------------------- */
#   if defined(FLT)
	MachData.Rounds = FLT_ROUNDS;
#   elif defined(DBL)
	MachData.Rounds = DBL_ROUNDS;
#   else
	MachData.Rounds = LDBL_ROUNDS;
#   endif

    /* ---------------- */
    /* Determine EpsNeg */
    /* ---------------- */

    T0 = (TYPE)1 / (TYPE)MachData.Radix;

    for (T1 = 1 - T0; T1 < (TYPE)1; T0 /= MachData.Radix)
    {
	T1 = (TYPE)1 - T0;
    }

    /* ---------------------- */
    /* Difference between 1.0 */
    /* & minimum number < 1.0 */
    /* ---------------------- */
    T2 = T0 * MachData.Radix;
    MachData.EpsNeg = T2;

    /* -------------------------------------- */
    /* Correct EpsNeg for Non-Binary Machines */
    /* -------------------------------------- */
    if (MachData.Radix != 2 && MachData.Rounds != 0)
    {
	T0 = T2 * (One + T2) / (One + One);
	T0 = One - T0;
	if (T0 - One != 0)
	    MachData.EpsNeg = T0;
    }

    /* ------------- */
    /* Determine Eps */
    /* ------------- */
    T0 = One / (TYPE) MachData.Radix;

    for (T1 = 1 + T0; T1 > 1; T0 /= MachData.Radix)
    {
	T1 = 1 + T0;
    }

    /* ---------------------- */
    /* Difference between 1.0 */
    /* & minimum number > 1.0 */
    /* ---------------------- */
    T2 = T0 * MachData.Radix;
    MachData.Eps = T2;

    /* ----------------------------------- */
    /* Correct Eps for Non-Binary Machines */
    /* ----------------------------------- */
    if (MachData.Radix != 2 && MachData.Rounds != 0)
    {
	T0 = T2 * (One + T2) / (One + One);
	T0 = One + T0;
	if (T0 - One != 0)
	    MachData.Eps = T0;
    }

    /* -------------------------- */
    /* Determine Number of Guard  */
    /* Digits Used Multiplication */
    /* -------------------------- */
    MachData.NumGuard = 0;
    if (MachData.Rounds == 0 &&
	(One + MachData.Eps) * One - One != Zero)
	MachData.NumGuard = 1;

    /* --------------------------------------------- */
    /* Determine ExpDigits, MaxExp, MinExp, Max, Min */
    /* --------------------------------------------- */
    T1 = One / (TYPE) MachData.Radix;

    /* ------------------------ */
    /* Count Digits in Exponent */
    /* ------------------------ */
    for (k = 0, n = 1;; ++k, n += n)
    {
	T2 = T1;
	T1 *= T1;
	T0 = T1 * One;
	if (T0 + T0 == Zero || T2 <= (T1 < 0 ? -T1 : T1))
	    break;
    }
    if (MachData.Radix != 10)
	MachData.ExpDigits = (short)(k + 1);
    else
	for (MachData.ExpDigits = 2, k = MachData.Radix; k <= n;)
	    ++MachData.ExpDigits, k *= MachData.Radix;

    /* ---------------- */
    /* Maximum Exponent */
    /* ---------------- */
#   if defined(FLT)
	MachData.MaxExp = FLT_MAX_EXP;
#   elif defined(DBL)
	MachData.MaxExp = DBL_MAX_EXP;
#   else
	MachData.MaxExp = LDBL_MAX_EXP;
#   endif
# if 0
    if (T0 != T1)
	MachData.MaxExp -= 2;
# endif

    /* ----------------------------- */
    /* Maximum Floating Point Number */
    /* ----------------------------- */
#   if defined(FLT)
	MachData.Max = FLT_MAX;
#   elif defined(DBL)
	MachData.Max = DBL_MAX;
#   else
	MachData.Max = LDBL_MAX;
#   endif

    /* ----------------------------- */
    /* Minimum Floating Point Number */
    /* ----------------------------- */
#   if defined(FLT)
	MachData.Min = FLT_MIN;
#   elif defined(DBL)
	MachData.Min = DBL_MIN;
#   else
	MachData.Min = LDBL_MIN;
#   endif

    /* ---------------- */
    /* Minimum Exponent */
    /* ---------------- */
#   if defined(FLT)
	MachData.MinExp = FLT_MIN_EXP;
#   elif defined(DBL)
	MachData.MinExp = DBL_MIN_EXP;
#   else
	MachData.MinExp = LDBL_MIN_EXP;
#   endif

    return MachData;
}
# if defined(TEST_MACHX)
void
main()
{
    MACHAR_STRU MachData;

    MachData = GetMachar();

    printf("Radix                  = %d\n"
	   "Fraction Digits        = %d\n"
	   "No. Mult. Guard Digits = %d\n",
	MachData.Radix,
	MachData.FracDigs,
	MachData.NumGuard);
    printf("ExpDigits              = %d\n"
           "MaxExp                 = %d\n"
	   "MinExp                 = %d\n",
	   MachData.ExpDigits,
	   MachData.MaxExp,
	   MachData.MinExp);
    printf("\nFloating Point Addition %ss\n\n",
	(MachData.Rounds) ? "Round" : "Chop");
    printf("Eps                 = %.10LG\n",
	(long double)MachData.Eps);
    printf("EpsNeg              = %.10LG\n",
	(long double)MachData.EpsNeg);
    printf("Max (Largest F.P.)  = %.10LG\n"
           "Min (Smallest F.P.) = %.10LG\n",
	   (long double)MachData.Max,
	   (long double)MachData.Min);
}
# endif			/* TEST */
# endif			/* __GETMACHX_H__ */
