The spectral test employs a library of functions that perform
100-digit floating point arithmetic.  The external functions
in this library are listed below with and a brief description.
These descriptions are followed by a description of q-type
data.

       EXTENDED PRECISION FLOATING POINT ROUTINES

Prototype		Purpose
---------		-------
asctoq(string, q)	ascii string to q type
dtoq(&d, q)		DEC double precision to q type
etoq(&d, q)		IEEE double precision to q type
e113toq(&d, q)		128-bit long double to q type
e64toq( &e, q )		80-bit IEEE long double to q type
ltoq(&l, q)		long integer to q type
qabs(q)			absolute value
qadd(a, b, c)		c = b + a
qclear(q)		q = 0
qcmp(a, b)		compare a to b
qdiv(a, b, c)		c = b / a
qifrac(x, &l, frac)	x to integer part l and q type fraction
qldexp(x, n)		multiply x by 2^n
qinfin(x)		set x to infinity, leave its sign alone
qmov(a, b)		b = a
qmul(a, b, c)		c = b * a
qmuli(a, b, c)		c = b * a, a has only 16 significant bits
qisneg(q)		returns sign of q
qneg(q)			q = -q
qnrmlz(q)		adjust exponent and mantissa
qsub(a, b, c)		c = b - a
qtoasc(a, s, n)		q to ASCII string, n digits after decimal
qtod(q, &d)		convert q type to DEC double precision
qtoe(q, &d)		convert q type to IEEE double precision
qtoe113(q, &d)		convert q type to 128-bit long double
qtoe64( q, &e )		q type to 80-bit IEEE long double


       EXTENDED PRECISION MATHEMATICAL FUNCTIONS


qexp( x, y )		y = exp( x )
qfloor( x, y )		y = largest integer not greater than x
qlog( x, y )		y = log( x ) [natural logarithm]
qpow( x, y, z )         z = x^y [x raised to the y power]
qrand( q )              q = pseudorandom number in [0,1)
qremain( a, b, c )	c = remainder after dividing b by a.
qround( x, y )		y = nearest integer to x
qsqrt( x, y )           y = sqrt( x )
qsrand( u )		initialize seed of qrand with unsigned int
qtanh( x, y )		y = tanh( x ) [hyperbolic tangent]


These routines operate on floating point data that consist of 24 words
of type short per datum.  The layout of this data type is:

      s   e   o    21-word significand
    | 1 | 2 | 3 | _____________________ |

    s - sign (0 for plus, -1 for minus)
    e - exponent (0x7fff at most, 0x4001 for 1.0)
    o - overflow from significand
