#include <stdio.h>
#include <stdlib.h>
#include <math.h>
// Verifies Minimum = 2^-16382       = 3.36210314311209350626E-4932
//          Maximum = 2^+16384 - eps = 1.18973149535723176502E+4932
void
main()
{
    long    k, m;
    double	F1 = pow(2, -1020), FSum = 0;

    for (k = 1021; k <= 1076; ++k)
    {
	F1 /= 2.0;
	if (k > 1020)
	printf("%5ld: F1 = %.20LE\n", k, (long double)F1);
	fflush(NULL);
    }

    fflush(NULL);
    printf("%4d: F1 - F1/2           = %.11LE\n",
	k, (long double)((long double)F1/2.0L));
    printf("%4d: F1 - F1/2 - F1/2 -  = %.11LE\n",
	k+1,
	(long double)((long double)F1 -
	(long double)(F1/2.0L) -
	(long double)(F1/2.0L)));

    m = 971;
    F1 = pow(2, m);
    FSum = pow(2, m);
    for (k = m+1; k <= 1024; ++k)
    {
	if (k > 1000)
	{
	    printf("%4ld: ", k);
	    fflush(NULL);
	}

	F1 *= 2.0;

	if (k > 1000)
	{
	    printf("F1 = %.20LE, ", (long double)F1);
	    fflush(NULL);
	}

	FSum += F1;

	if (k > 1000)
	{
	    printf("F1 = %.20LE\n", (long double)FSum);
	    fflush(NULL);
	}
    }
    //fflush(NULL);
    //printf("%4ld: F1*2 = %.11E\n", k, (long double)F1*2);
    //printf("%4ld: F1*4 = %.11E\n", k, (long double)F1*4);
}
