# MSDOS Microsoft C makefile for Cephes library
CFLAGS=/c
# For large memory model:
#CFLAGS=/c /AL
# Add /FPa to the CFLAGS if you want to use the fast software FPa arithmetic.
#
# Use the following with /FPa if you do not want to use the 80x87 coprocessor
# or software emulator.

# Use the following instead if you want to use an 80x87 chip or
# software emulator for maximum accuracy computation of the
# polynomial expansions:

mtst.exe: mtst.obj fti.lib
	link mtst,,,fti.lib

mtst.obj: mtst.c mconf.h
	cl /c mtst.c

OBJECTS = acosh.obj airy.obj asin.obj asinh.obj atan.obj atanh.obj bdtr.obj \
beta.obj btdtr.obj cbrt.obj chbevl.obj chdtr.obj clog.obj \
cmplx.obj const.obj cosh.obj dawsn.obj drand.obj ellie.obj ellik.obj \
ellpe.obj ellpj.obj ellpk.obj exp.obj exp10.obj \
exp2.obj expn.obj fabs.obj fac.obj fdtr.obj floor.obj fresnl.obj gamma.obj \
gdtr.obj hyp2f1.obj hyperg.obj i0.obj i1.obj igam.obj igami.obj incbet.obj \
incbi.obj iv.obj j0.obj j1.obj jn.obj jv.obj k0.obj k1.obj kn.obj \
log.obj log2.obj log10.obj mtherr.obj nbdtr.obj ndtr.obj ndtri.obj \
pdtr.obj polevl.obj pow.obj powi.obj psi.obj rgamma.obj round.obj shichi.obj \
sici.obj sin.obj sindg.obj sinh.obj spence.obj sqrt.obj stdtr.obj struve.obj \
tan.obj tandg.obj tanh.obj yn.obj zeta.obj zetac.obj

fti.lib: $(OBJECTS)
	lib @ftiasm.rsp \;
	@mv -f fti.bak fti.old

acosh.obj:	acosh.c		mconf.h
airy.obj:	airy.c		mconf.h
asin.obj:	asin.c		mconf.h
asinh.obj:	asinh.c		mconf.h
atan.obj:	atan.c		mconf.h
atanh.obj:	atanh.c		mconf.h
bdtr.obj:	bdtr.c		mconf.h
beta.obj:	beta.c		mconf.h
btdtr.obj:	btdtr.c
cbrt.obj:	cbrt.c		mconf.h
chbevl.obj:	chbevl.c
chdtr.obj:	chdtr.c		mconf.h
clog.obj:	clog.c		mconf.h
cmplx.obj:	cmplx.c		mconf.h
const.obj:	const.c		mconf.h
cosh.obj:	cosh.c		mconf.h
dawsn.obj:	dawsn.c		mconf.h
drand.obj:	drand.c		mconf.h
ellie.obj:	ellie.c
ellik.obj:	ellik.c
ellpe.obj:	ellpe.c		mconf.h
ellpj.obj:	ellpj.c		mconf.h
ellpk.obj:	ellpk.c		mconf.h
exp.obj:	exp.c		mconf.h
exp10.obj:	exp10.c		mconf.h
exp2.obj:	exp2.c		mconf.h
expn.obj:	expn.c		mconf.h
fabs.obj:	fabs.c
fac.obj:	fac.c		mconf.h
fdtr.obj:	fdtr.c		mconf.h
floor.obj:	floor.c		mconf.h
fresnl.obj:	fresnl.c	mconf.h
gamma.obj:	gamma.c		mconf.h
gdtr.obj:	gdtr.c		mconf.h
hyp2f1.obj:	hyp2f1.c	mconf.h
hyperg.obj:	hyperg.c	mconf.h
i0.obj:		i0.c		mconf.h
i1.obj:		i1.c		mconf.h
igam.obj:	igam.c		mconf.h
igami.obj:	igami.c		mconf.h
incbet.obj:	incbet.c	mconf.h
incbi.obj:	incbi.c		mconf.h
iv.obj:		iv.c		mconf.h
j0.obj:		j0.c		mconf.h
j1.obj:		j1.c		mconf.h
jn.obj:		jn.c		mconf.h
jv.obj:		jv.c		mconf.h
k0.obj:		k0.c		mconf.h
k1.obj:		k1.c		mconf.h
kn.obj:		kn.c		mconf.h
log.obj:	log.c		mconf.h
log2.obj:	log2.c		mconf.h
log10.obj:	log10.c		mconf.h
mtherr.obj:	mtherr.c	mconf.h
nbdtr.obj:	nbdtr.c		mconf.h
ndtr.obj:	ndtr.c		mconf.h
ndtri.obj:	ndtri.c		mconf.h
pdtr.obj:	pdtr.c		mconf.h
polevl.obj:	polevl.c
	cl /c /Ox polevl.c

#polevl.obj: polevl.asm
#	masm  polevl.asm \;

pow.obj:	pow.c
powi.obj:	powi.c		mconf.h
psi.obj:	psi.c		mconf.h
rgamma.obj:	rgamma.c	mconf.h
round.obj:	round.c
shichi.obj:	shichi.c	mconf.h
sici.obj:	sici.c		mconf.h
sin.obj:	sin.c		mconf.h
sindg.obj:	sindg.c		mconf.h
sinh.obj:	sinh.c		mconf.h
spence.obj:	spence.c	mconf.h
sqrt.obj:	sqrt.c		mconf.h
stdtr.obj:	stdtr.c		mconf.h
struve.obj:	struve.c
tan.obj:	tan.c		mconf.h
tandg.obj:	tandg.c		mconf.h
tanh.obj:	tanh.c		mconf.h
yn.obj:		yn.c		mconf.h
zeta.obj:	zeta.c		mconf.h
zetac.obj:	zetac.c		mconf.h
