Listing 1: AThread.h
--------------------------------------------------------------------------
// AThread.h - Thread interface
// abstract base class.

#ifndef _ATHREAD_
#define _ATHREAD_

class AThread {
public:
   AThread  () { mState = RUN; }
   virtual ~AThread ()
      { if (mState != DEAD) Kill(TRUE); }

   BOOL IsRunning() { return (mState == RUN); }
   BOOL IsDead()    { return (mState == DEAD); }

   virtual void Kill(BOOL force) = 0;

   virtual void Run() { CheckStatus(); }

protected:
   enum ThreadState { RUN, TERMINATE, DEAD };

   virtual void CheckStatus() = 0;
   virtual void LockHandle() = 0;
   virtual void UnlockHandle() = 0;
   volatile ThreadState mState;
};

#endif
