#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define ARR_SIZE      500000

int main(void)
{
  double arr[ARR_SIZE][2];
  double dist, min_dist;
  double dist2, min_dist2;
  double sqrt_field, no_sqrt_field;
  double ptx = 1.5, pty = 0.5;
  double dx, dy;
  long i, j;
  clock_t start_clock, end_clock;
  clock_t clock_sqrt, clock_no_sqrt;


  /* seed random number generator from time */
  srand((unsigned int)time(0));


  /* initialize arrays: uniform random 0.0 - 1.0 */
  for (i = 0; i < ARR_SIZE; i++)
    for (j = 0; j < 2; j++)
      arr[i][j] = rand() / (double)RAND_MAX;

/* find nearest neighbor as min(curr_min, sqrt(dx*dx + dy*dy)) */
/* and as min(curr_min, dx*dx + dy*dy) */
  start_clock = clock();
  dx = arr[0][0] - ptx;
  dy = arr[0][1] - pty;
  min_dist = sqrt(dx*dx + dy*dy);
  for (i = 0; i < ARR_SIZE; i++)
  {
    dx = arr[i][0] - ptx;
    dy = arr[i][1] - pty;
    dist = sqrt(dx*dx + dy*dy);
    if (dist < min_dist)
      min_dist = dist;
  }
  end_clock = clock();
  clock_sqrt = end_clock - start_clock;
  start_clock = end_clock;
  dx = arr[0][0] - ptx;
  dy = arr[0][1] - pty;
  min_dist2 = dx*dx + dy*dy;
  for (i = 0; i < ARR_SIZE; i++)
  {
    dx = arr[i][0] - ptx;
    dy = arr[i][1] - pty;
    dist2 = dx*dx + dy*dy;
    if (dist2 < min_dist2)
      min_dist2 = dist2;
  }
  end_clock = clock();
  clock_no_sqrt = end_clock - start_clock;
  printf("min = %f = %f\n", min_dist, sqrt(min_dist2));
  printf("sqrt()    time: %10.1f\n", clock_sqrt / (double)CLOCKS_PER_SEC);
  printf("no sqrt() time: %10.1f\n", clock_no_sqrt / (double)CLOCKS_PER_SEC);


  /* Then calculate effect that is sum of 1/x^2 both ways */
  start_clock = clock();
  sqrt_field = 0.0;
  for (i = 0; i < ARR_SIZE; i++)
  {
    dx = arr[i][0] - ptx;
    dy = arr[i][1] - pty;
    dist = sqrt(dx*dx + dy*dy);
    sqrt_field += 1.0 / (dist * dist);
  }
  end_clock = clock();
  clock_sqrt = end_clock - start_clock;
  start_clock = end_clock;
  no_sqrt_field = 0.0;
  for (i = 0; i < ARR_SIZE; i++)
  {
    dx = arr[i][0] - ptx;
    dy = arr[i][1] - pty;
    dist2 = dx*dx + dy*dy;
    no_sqrt_field += 1.0 / dist2;
  }
  end_clock = clock();
  clock_no_sqrt = end_clock - start_clock;
  printf("inverse square field = %f = %f\n", sqrt_field, no_sqrt_field);
  printf("sqrt()    time: %10.1f\n", clock_sqrt / (double)CLOCKS_PER_SEC);
  printf("no sqrt() time: %10.1f\n", clock_no_sqrt / (double)CLOCKS_PER_SEC);

  /* Sum pow(dist, -6.0) vs pow(dist2, -3.0) */
  start_clock = clock();
  sqrt_field = 0.0;
  for (i = 0; i < ARR_SIZE; i++)
  {
    dx = arr[i][0] - ptx;
    dy = arr[i][1] - pty;
    dist = sqrt(dx*dx + dy*dy);
    sqrt_field += pow(dist, -6.0);
  }
  end_clock = clock();
  clock_sqrt = end_clock - start_clock;
  start_clock = end_clock;
  no_sqrt_field = 0.0;
  for (i = 0; i < ARR_SIZE; i++)
  {
    dx = arr[i][0] - ptx;
    dy = arr[i][1] - pty;
    dist2 = dx*dx + dy*dy;
    no_sqrt_field += pow(dist2, -3.0);
  }
  end_clock = clock();
  clock_no_sqrt = end_clock - start_clock;
  printf("inverse sixth power field = %f = %f\n", sqrt_field, no_sqrt_field);
  printf("sqrt()    time: %10.1f\n", clock_sqrt / (double)CLOCKS_PER_SEC);
  printf("no sqrt() time: %10.1f\n", clock_no_sqrt / (double)CLOCKS_PER_SEC);

  return EXIT_SUCCESS;
}
