namespace std {
  template <class charT>
  class char_traits {
     typedef charT char_type;
     typedef int int_type;
     typedef streampos pos_type;
     typedef streamoff off_type;
     typedef mbstate_t state_type;

     static void asign( char_type &c1, const char_type &c2);
     static bool eq( const char_type &c1, const char_type &c2 );
     static bool lt( const char_type &c1, const char_type &c2 );

     static int compare( const char_type *s1, const char_type *s2, size_t n );
     static size_t length( const char_type *s );
     static const char_type *find( const char_type *s, int n, 
                                   const char_type &a );
     static char_type *move( char_type *s1,
                             const char_type *s2,
                             size_t n );
     static char_type *copy( char_type *s1,
                             const char_type *s2,
                             size_t n );
     static char_type *assign( char_type *s,
                               size_t n,
                               char_type a );

     static int_type not_eof( const int_type &c );
     static char_type to_char_type( const int_type &c );
     static int_type to_int_type( const char_type &c );
     static bool eq_int_type( const int_type &c1,
                              const int_type &c2 );
     static state_type get_state( pos_type pos );
     static pos_type get_pos( streampos pos, state_type state );
     static int_type eof();
  };
}
