/* mru.h
 * Copyright (c) 1995 T.W. Nelson.  Permission
 * is hereby granted to use this code in any
 * manner provided the user display this
 * copyright notice in the source
 */
#if !defined(__MRU_H)
#define __MRU_H
#include "genlist.h"    /* Container interface */

typedef unsigned long ulong;

#define StdAlloc TStandardAllocator

class MruAlloc : public StdAlloc
{
  public:
    void *operator new( size_t sz )
        { return ::operator new(sz); }
    void *operator new [] ( size_t sz )
        { return ::operator new [] (sz); }
};

class CacheNode  {
    CacheNode( const CacheNode& );  //undefined
    CacheNode& operator= (const CacheNode&); //undefined
  public:
    enum Status { Release, Mark };
    CacheNode(int objsz):
        _stat(Release),_tag(-1)
        { _obj = MruAlloc::operator new (objsz); }
    ~CacheNode()
        {   if(_obj)
                MruAlloc::operator delete(_obj);
        }
    int _stat;    /* node status */
    ulong _tag;   /* object id# */
    void * _obj;  /* -> user object storage */
    int operator == (CacheNode & p)
        { return _tag == p._tag; }

    void *operator new( size_t sz )
        { return MruAlloc::operator new(sz); }
    void operator delete( void *p )
        { MruAlloc::operator delete(p); }
};

class MruCache  {
  protected:
    #ifdef TESTING
    ulong _hits, _miss, _adds;  /* cache stats */
    #endif

    int _nodes;     /* # CacheNodes allocated */
    CacheNode *Mru, *Lru;
    TIGenDoubleList<CacheNode,StdAlloc> *Cm;
    TIGenDoubleListIterator<CacheNode,StdAlloc> *Itr;
    CacheNode *make_mru(CacheNode *);
    virtual void Proc(const CacheNode *) = 0;

  public:
    MruCache(int nn,int objsz);
    virtual ~MruCache ();
    MruCache( const MruCache& );  //undefined
    MruCache& operator= (const MruCache&); //undefined
    CacheNode *Search( ulong );
    CacheNode *AddNew( ulong );
    CacheNode *Mark( ulong, CacheNode::Status );
    void Flush();

    void * operator new( size_t sz )
        { return MruAlloc::operator new(sz);  }
    void operator delete( void *p )
        { MruAlloc::operator delete(p);       }

    #if defined( TESTING )
    ulong Hits() const { return _hits; }
    ulong Miss() const { return _miss; }
    ulong Adds() const { return _adds; }
    CacheNode *MruNode() const { return Mru; }
    CacheNode *LruNode() const { return Lru; }
    TIGenDoubleList<CacheNode,StdAlloc>
                  *Cman() const { return Cm; }
    #endif
};
#endif  //EOF
