/*
 *  examp.cpp
 *  Source code Copyright (c) 1995 T.W. Nelson.
 *  This source (including derivations thereof) may
 *  be used in any manner provided copyright notice
 *  is displayed appropriately.
 *
 */

#include <iostream.h>
#include <iomanip.h>
#include "mru.h"

struct Data { int a, b, c; };   //test object
const int NODES = 10;

template <class T>      //MruCache instance class
class TMruCache : public MruCache   {
  protected:
    void Proc(const CacheNode *);
  public:
    TMruCache(int nn): MruCache(nn,sizeof(T)) {}
    ~TMruCache () {}
};

template <class T>
void TMruCache<T>::Proc(const CacheNode *p)
{   /* default node processor....... */
    #if defined( TESTING )
    cout << "Processing block# "
         << (signed long) p->_tag << endl;
    #endif
}

int select( TMruCache<Data> &P )
{
    unsigned char option = 0;
    long num;

    cout << "\n[Q]uit, [A]ddNew,"
         << " [S]earch, [M]ark, [F]lush... ";
    cin >> option;

    switch( option )
    {
    case    'Q':
    case    'q':
        return 0;       //quit
    case    'A':
    case    'a':
        cout << "Enter object to Add: ";
        cin  >> num;
        P.AddNew(num);
        return 1;
    case    'S':
    case    's':
        cout << "Enter object to search: ";
        cin  >> num;
        if( P.Search( num ) == 0 )
            cout << "Object #" << num << " NOT found\n";
        return 1;
    case    'M':
    case    'm':
        cout << "Enter object to mark: ";
        cin  >> num;
        P.Mark( num, CacheNode::Mark );
        return 1;
    case    'F':
    case    'f':
        P.Flush();
        return 1;
    default:
        return 1;
    }
}

void print_status( TMruCache<Data> & P )
{
    CacheNode *lru = P.LruNode();
    CacheNode *mru = P.MruNode();

    cout << "Cache statistics: Hits = " << P.Hits()
         << " Miss = " << P.Miss()
         << " Adds = " << P.Adds() << endl;
    cout << "Object#  Status"
         << " MRU = " << (signed long) mru->_tag
         << " LRU = " << (signed long) lru->_tag << endl;
    cout << "------- -------" << endl;

    TIGenDoubleListIterator<CacheNode,StdAlloc>
                                itr( *P.Cman() );
    CacheNode * p;
    cout.setf( ios::left, ios::adjustfield );
    while( (p = itr++) != 0 )
        cout << setw(11) << (signed long) p->_tag
             << p->_stat << endl;
}

int main()
{
    TMruCache<Data> mru(NODES);

    for( int i = 1; i <= NODES; i++ )
        mru.AddNew((ulong) i);

    do {    print_status(mru);
    } while( select(mru) );

    return 0;
}
//EOF
