/* ----------------------------------------------------
 *  Filename:           cfile.cpp
 *  Summary:            class CachedFile: i/o interface
 *                      to C++ cache manager
 *  Author:             T.W. Nelson
 *  Compile options:    
 *  Version:            1.5
 *  Start Date:         09-Oct-1994
 *  Last Update:        31-Aug-1995
 *  Notes:
 *
 *  Source code Copyright (c) 1995 T.W. Nelson.
 *  This source (including derivations thereof) may
 *  be used in any manner provided copyright notice
 *  is displayed appropriately.
 * ------------------------------------------------- */

#include <mem.h>    /* memcpy() */
#include "cfile.h"

void CachedFile::init()
{
    Fp = new BinaryFile( _size );

    if( _fname == 0 || *_fname == 0 )  /* temp file */
    {
        _fname = 0;
        _mode |= CreateTemp;
    }
    else if( Fp->Open(_fname) )   /* std open or create */
        Fp->Create(_fname);

    /* hang out the sign ...... */
    _mode |= IsOpen;
}

void CachedFile::commit( const CacheNode *p )
{
   /* Cache node processor function; writes a cache
    * node to disk.  Called by the cache manager when
    * a cache block must be re-used for new data.
    */

    if( _fname == 0 )    /* if no file, create one */
    {
        _fname = tmpnam(_tmpbuf);

        if( Fp->Create( _fname ) )
            _mode |= IoErr; /* error */
    }

    Fp->WritePos( p->_tag, p->_obj );
}

int CachedFile::read_object( void * dest, ulong ofst )
{
    CacheNode *p;

    if((p = Search( ofst )) == 0 )
    {
        p = AddNew( ofst );

        if( Fp->ReadPos( ofst, p->_obj ) == -1 )
            return -1;  /* error */
    }

    memcpy( dest, p->_obj, _size );   /* copy from cache to dest */

    return 0;         /* OK */
}

int CachedFile::write_object(const void *src, ulong ofst)
{
    CacheNode *p;

    if( _mode & ReadOnly )
        return -1;      /* disallow writes */

    if((p = Search( ofst )) == 0 )
        p = AddNew( ofst );

    memcpy( p->_obj, src, _size );    /* update the cache block */

    if( _mode & WriteThru )
            Proc( p );     /* process immediately */
    else      /* mark for delayed processing */
            p->_stat = CacheNode::Mark;

    return 0;
}
/* ----- EOF --------------------------------------- */
