// heapptr.h listing 2
// copyright 1995 Robert Mashlan

#ifndef __HEAPPTR_H
#define __HEAPPTR_H

#include <stddef.h>

template<class T>
class HeapPtr {
    public:
      // constructor for arrays
      HeapPtr( size_t nelems )
         : pref(Ref::newRef(new T[nelems],1))
         {}
      // constructor for non-arrays
      HeapPtr( T* p = 0 )
         : pref(Ref::newRef(p))
         {}
      // copy constructor
      HeapPtr( const HeapPtr<T>& orig )
         : pref(orig.pref->copyRef())
         {}
      ~HeapPtr()
         { pref->delRef(); }

      T* getp() const
         { return pref->getp(); }
      // operators
      operator T*() const
         { return getp(); }
      HeapPtr<T>& operator=( const HeapPtr<T>& orig )
         {
            pref->delRef();
            pref=orig.pref->copyRef();
            return *this;
         }
      HeapPtr<T>& operator=( size_t nelems )
         {
           pref->delRef();
           pref = Ref::newRef(new T[nelems],1);
           return *this;
         }
      HeapPtr<T>& operator=( T* p )
         {
           pref->delRef();
           pref = Ref::newRef(p);
           return *this;
         }
      HeapPtr<T>& operator()( size_t nelems )
         { return operator=(nelems); }
      HeapPtr<T>& operator()( T *p )
         { return operator=(p); }
      HeapPtr<T>& operator()( const HeapPtr<T>& hp )
         { return operator=(hp); }
      HeapPtr<T>& empty()
         { return operator=((T*)0); }
   protected:
      class Ref {
         public:
            static Ref *newRef( T *p, bool isarray=false )
               { return new Ref(p,isarray); }
            void delRef()
               { ref--; if(ref==0) delete this;  }
            Ref *copyRef()
               { ref++; return this; }
            T* getp() const
               { return p; }
         protected:
            Ref( T* p, bool isarray )
               : ref(1), p(p), isarray(isarray)
               {}
            ~Ref()
               { isarray ? delete []p : delete p; }
            T *p;
            long ref;
            bool isarray;
      };
      Ref *pref;
};

#endif
