// cptest.cpp listing 3
// copyright 1995 Robert Mashlan
// demonstrations of the CheckedPtr, CheckedClassPtr
// and HeapPtr class templates.

#include <iostream.h>

// remove the following if the C++ implements
// a built-in bool type

typedef int bool;
enum { false, true };

#include "checkptr.h"
#include "heapptr.h"


#define DO(exp) cout << #exp << ";" << endl; exp

void f1()
{
   cout << "f1()" << endl;
   DO( char buf[] = "test" );
   DO( CheckedPtr<char> p(buf,sizeof(buf)) );
   DO( *p = 1 );
   DO( *p = 'r'); // ok
   DO( p = 0 );   // now a null pointer
   DO( *p = 'r'); // error - dereferenced null pointer
}

void f2()
{
   cout << "f2()" << endl;
   DO( HeapPtr<char> a );
   DO( const CheckedPtr<char> p(a(100),100) ); // allocate an array of 100 char
   DO( for(int i=0;i<100;i++) p[i] = 0 ); // OK
   DO( p[i] = 0 ); // out of range
}

void f3()
{
   cout << "f3()" << endl;
   DO( HeapPtr<char> a(100));
   DO( const CheckedPtr<char> pa(a,100) );
   // technically OK, but fails range check for the expression &v[100]
   DO( for(CheckedPtr<char> p=pa; p<&pa[100]; p++) *p=0 );
}

void f4()
{
   cout << "f4()" << endl;
   DO( HeapPtr<char> a );
   DO( const CheckedPtr<char> pa(a(100),100) );  // array of 100 char
   DO( for( CheckedPtr<char> p=pa;p<pa+100; p++) *p=0 ); // OK
   DO( *p = 0 ); // error
}

void f5()
{
   cout << "f5()" << endl;
   DO(int i);
   DO(CheckedPtr<int> vi = &i );
   DO(*vi = 0);
   DO(vi++); // OK
   DO(vi++); // error
}

void f6()
{
   cout << "f6()" << endl;
   DO( int i );
   DO( CheckedPtr<int> vi = &i );
   DO( *vi = 0 );
   DO( vi++ );     // OK
   DO( *vi = 0 );  // error
}

void f7()
{
   cout << "f7()" << endl;

   class A {
      public:
         A(int i=0) : i(i) {};
         void f(int d) { i=d; }
      private:
         int i;
   };

   DO( HeapPtr<A> hp; );
   DO( CheckedClassPtr<A> pa(hp(10),10) );
   DO( for( CheckedClassPtr<A> p = pa; p < pa+10; p++ ) pa->f(1) );
   DO( for(int i=0;i<10;i++) (pa+i)->f(i) );  // OK
   DO( p->f(1) );  // error
}

void f8()
{
   cout << "f8()" << endl;
   DO( HeapPtr<char> a );
   DO( HeapPtr<char> b );
   DO( const CheckedPtr<char>pa(a(100),100) );
   DO( const CheckedPtr<char>pb(b(100),100) );
   DO( CheckedPtr<char>p; );
   DO( for(p=pa; p<pa+100; p++) );  // ok
   DO( for(p=pb; p<pa+100; p++) );  // error
}

void f9()
{
   cout << "f9()" << endl;
   DO( int a[10] );
   DO( CheckedPtr<int> cpa(a,10) );
   DO( CheckedPtr<int> cpb(a+10,10,a) );
   DO( int *b = cpb; );
   DO( int i );
   DO( for(i=0;i<10;i++) cpa[i] = i );

   DO( cout << (cpa==a) << endl );
   DO( cout << (cpa==cpb) << endl );
   DO( cout << (a==cpa) << endl );

   DO( cout << (cpa!=a) << endl );
   DO( cout << (a!=cpa) << endl );
   DO( cout << (cpa!=cpb) << endl );

   DO( cout << (cpa<a) << endl );
   DO( cout << (a<cpa) << endl );
   DO( cout << (cpa<cpb) << endl );

   DO( cout << (cpa<=a) << endl );
   DO( cout << (a<=cpa) << endl );
   DO( cout << (cpa<=cpb) << endl );

   DO( cout << (cpa>a) << endl );
   DO( cout << (a>cpa) << endl );
   DO( cout << (cpa>cpb) << endl );

   DO( cout << (cpa>=a) << endl );
   DO( cout << (a>=cpa) << endl );
   DO( cout << (cpa>=cpb) << endl );

   cout << endl;
   DO( for(i=0; i<10; i++) cout << *(cpa+i) );
   cout << endl;
   DO( for(i=0; i<10; i++) cout << *(i+cpa) );
   cout << endl;
   DO( for(i=10; i>0; i--) cout << *(cpb-i) );
   cout << endl;


   DO( cout << (a-cpa)  << endl );
   DO( cout << (cpa-a) << endl );
   DO( cout << (cpb-cpa) << endl );
   DO( cout << (cpa-b)  << endl );
   DO( cout << (b-cpa) << endl );

}

void test( void (*f)() )
// run a test function, and display the exception information
{
   cout << endl;
   try {
      f();
   }
   catch( xCheckedPtr x ) {
      cout << "xCheckedPtr exception: " << x.why() << endl;
   }
}

int main(void)
{
   test(f1);
   test(f2);
   test(f3);
   test(f4);
   test(f5);
   test(f6);
   test(f7);
   test(f8);
   test(f9);
   return 0;
}
