/* Listing 4, printf.c, version 1 */
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "check.h"	/* Listing 1 */
#include "printf.h"	/* Listing 3 */

const char srcCall[] = 
  "int printf(const char format[],...)";

int DB_printf( const char format[], ... )
  {
  va_list ap;
  int returnValue;

  UNDEFINED_IF(format == NULL);
  WARNING_IF(strchr(format, '%') == NULL);
  WARNING_IF(strstr(format, "%ul") != NULL);
  WARNING_IF(strstr(format, "%p") != NULL);
  va_start(ap, format);
  returnValue = vprintf(format, ap);
  va_end(ap);
  WARNING_IF(returnValue < 0);
  return returnValue;
  }

