Listing 3

void scale_smooth
        (PIXEL *src, int srcWidth,
        PIXEL *dest, int destWidth)
{
  int pixelFrac=destWidth;
  int srcPos=0, destPos=0;

  while(destPos < destWidth) {
    PIXEL p = 0;
    int numerator = 0;

    /* Handle whole pixels first */
    while (numerator+pixelFrac
	   <= srcWidth) {
      numerator += pixelFrac;
      p += pixelFrac*src[srcPos++];
      pixelFrac = destWidth;
    }
    if (numerator < srcWidth)
    { /* Partial pixel? */
      p += (srcWidth-numerator)
             * src[srcPos];
      pixelFrac -= srcWidth
                   - numerator;
    }
    dest[destPos++]= p / srcWidth;
  }
}
