// [CLASS] Implementation
//////////////////////////////////////////////////////
#include "[CLASS].HPP"
#[ NewHandler = 1
#include <new.h>
#]
#include <assert.h>

#[ CountInst = 1
unsigned long [CLASS]::_HowMany;
#]

// default constructor
[CLASS]::[CLASS]()
{
_commonCtorJob();
//...
}

#[ CCAO = 0
// copy constructor
[CLASS]::[CLASS](const [CLASS]& y)
{
_commonCtorJob();
//...
}

// assignment overload
[CLASS]& [CLASS]::operator=(const [CLASS]& y)
{
invariant();
if(this == &y)
	return *this;
//...
#[ CRC = 1
_setCRC();
#]
return *this;
}
#]

// called from all constructors
void [CLASS]::_commonCtorJob()
{
#[ CountInst = 1
_HowMany++;
#]
//...

#[ CRC = 1
_setCRC();
#]
}

// destructor
[CLASS]::~[CLASS]()
{
#[ CRC = 1
#if !defined(NDEBUG)
_crcVal = ~_crcVal;
#endif
#]
#[ CountInst = 1
_HowMany--;
#]
//...
}

#[ CountInst = 1
// instance count
unsigned long [CLASS]::HowMany()
{
return _HowMany;
}
#]

#[ NewHandler = 1
void * [CLASS]::operator new(size_t size)
{
void (*sav)() = ::set_new_handler([CLASS]::NoMemory);
void *mem = ::new char[size];
::set_new_handler(sav);
return mem;
}

void [CLASS]::NoMemory()
{
//...
}
#]

void [CLASS]::invariant()
{
#[ CountInst = 1
assert(_HowMany > 0);
#]
#[ CRC = 1
#if !defined(NDEBUG)
unsigned short _lastCRC = _crcVal;
_crcVal = 0;
assert(_crc() == _lastCRC);
_crcVal = _lastCRC;
#endif
#]
//...
}

#[ CRC = 1
#if !defined(NDEBUG)
#include <stddef.h>	// for size_t definition
unsigned short [CLASS]::_crc()
{
const unsigned short POLY = 0x8408;
unsigned char i;
unsigned short data,crc;
unsigned char* data_p = (unsigned char*)this;
size_t length = sizeof([CLASS]);
crc=0xffff;
do{
	for(i=0 , data = (unsigned short)0x00ff & *(data_p++); i < 8;
		i++ , data >>= 1)
		if((crc & 0x0001) ^ (data & (unsigned short)0x0001))
			 crc=(crc >> 1) ^ POLY;
		  else
			  crc>>=1;
   } while(--length > 0);
crc=~crc;
data=crc;
crc=(crc << 8) | ((data >> 8) & (unsigned short)0x00ff);
return(crc);
}
#endif	// !NDEBUG
#]
