////////////////////////////////////////////////////////////////////
//
#ifndef __SPATH__
#define __SPATH__

#ifndef _VECTOR_
#include <vector>
#endif
#ifndef _QUEUE_
#include <queue>
#endif
#ifndef _ALGORITHM_
#include <algorithm>
#endif
#ifndef _FUNCTIONAL_
#include <functional>
#endif

#if defined(__BORLANDC__) || (_MSC_VER >= 1100 )
    using namespace std;
#endif


// reduce the symbol size for debug builds; MS compilers truncate
// symbols at 255 characters
#ifdef _DEBUG
#define my_priority_queue mpq_
#define distance_less dl_
#endif

// my_priority_queue is a priority_queue that also allows you to 
// change the value of a key already inside the queue; this 
// implementation is inefficient in that it delegates to make_heap().
// used by shortest_path_heap_dijkstrka

// Visual C++ 5.0 changed the template parameters to priority_queue, 
// so to derive from priority_queue we must check versions.
#if _MSC_VER == 1100
    template<class _TYPE, class _C, class _Pr>
    class my_priority_queue : public priority_queue<_TYPE, _C, _Pr> 
#else
    template<class _TYPE, class _C, class _Pr, class _A>
    class my_priority_queue : public priority_queue<_TYPE,_C,_Pr,_A> 
#endif
{
public:
    my_priority_queue() {}
    my_priority_queue(const _Pr& _X, const allocator_type& _Al) :
#if _MSC_VER == 1100
        priority_queue<_TYPE, _C, _Pr>(_X, _Al) {}
#else
        priority_queue<_TYPE, _C, _Pr, _A>(_X, _Al) {}
#endif
    my_priority_queue(_It _F, _It _L, const _Pr& _X = _Pr(),
        const allocator_type& _Al = allocator_type()) : 
#if _MSC_VER == 1100
        priority_queue<_TYPE, _C, _Pr>(_F, _L, _X, _Al) {}
#else
        priority_queue<_TYPE, _C, _Pr, _A>(_F, _L, _X, _Al) {}
#endif
        
    // new functionality
    void change_key(const value_type& _old, const value_type& _new)
        { _C::iterator loc = find(c.begin(), c.end(), _old);
          // replace old with new
          if( !(loc==c.end()) )
              *loc = _new;
          // inefficient: delegate to make_heap()
          make_heap(c.begin(), c.end(), comp);
        }
    void decrease_key(const value_type& _old, const value_type& _new)
        { change_key(_old, _new); }


};

/*
The predicate to the shortest-path routines must be like:

struct PRED
{
    typedef T0 value_type;
    static const value_type infinity;
    static const value_type zero;
    value_type operator()(const _ARC& arc) const;
};

value_type T0 needs (built-in types already defined):

T0 operator+(const T0& left, const T0& right);
T0 operator<(const T0& left, const T0& right);
*/

    // template struct distance_less
    //  compares second element of a pair<>
    // used by shortest_path_heap_dijkstrka
template<class _ELEM>
struct distance_less : public binary_function<_ELEM, _ELEM, bool>
{
    bool operator()(const _ELEM& x, const _ELEM& y) const
        {return x.second > y.second;}
};


    // TEMPLATE FUNCTION shortest_path WITH PRED
    // dies if there's a negative-length cycle

// needs a helper class for heap management; I use my_priority_queue
// defined above, though that helper is inefficient.

template<class _NET, class _NETNODEIT, class _NETNODESIZE, 
         class _Pr, class _PRTYPE> inline
bool shortest_path_heap_dijkstra(_NET& _N, _NETNODEIT _S, 
        vector<_NETNODESIZE, allocator<_NETNODESIZE> >& _pred, 
        vector<_PRTYPE, allocator<_PRTYPE> >& _dist,  _Pr& _P)
{
    typedef _PRTYPE distance_type;
    typedef _NETNODESIZE size_type;
    typedef pair<size_type, distance_type> _qe;

#if _MSC_VER == 1100
    typedef my_priority_queue<_qe, vector<_qe, allocator<_qe> >, 
        distance_less<_qe> > _queue;
#else
    typedef my_priority_queue<_qe, vector<_qe, allocator<_qe> >, 
        distance_less<_qe>, allocator<_qe> > _queue;
#endif
    _NET::node_iterator nit;
    _NET::arc_iterator ait;
    distance_type _val;
    size_type _j, _i;

    // set up the distances vector
    vector<distance_type, allocator<distance_type> > 
        _distances(_N.size_nodes(), _Pr::infinity);
    _queue _Q;  // the heap
    // make the predecessor vector correct size
    _pred.resize(_N.size_nodes());

    // algorithm initialization: 
    // label the source node and place in queue
    _distances[_S - _N.begin_nodes()] = _Pr::zero;
    _Q.push(_qe(_S-_N.begin_nodes(), _Pr::zero));

    // invariant: once a node is removed for the queue, its distance
    // label is optimal
    while( !_Q.empty() )
    {
        // get a node from the queue
        _i = _Q.top().first;
        nit = _N.begin_nodes()+_i;
        _Q.pop();
        // for each arc leaving this node
        for(ait=_N.begin_arcs(nit); !(ait==_N.end_arcs(nit)); ait++)
        {
            // get distance label of node plus length of current arc
            _val = _distances[_i] + _P(*ait);
            // get destination node
            _j = _N.arcDestinNode(ait);
            // if this distance is better than the current distance
            // to the destination node, then update it
            if( _val < _distances[_j] )
                if( _distances[_j] == _Pr::infinity )
                {
                    // first time it's been updated, 
                    // so place in the queue
                    _distances[_j] = _val;
                    _pred[_j] = _i;
                    _Q.push(_qe(_j,_distances[_j]));
                }
                else
                {
                    // it's already in queue, so update its distance
                    _pred[_j] = _i;
                    _Q.decrease_key(_qe(_j, _distances[_j]), 
                        _qe(_j, _val));
                    _distances[_j] = _val;
                }
        }
    }
    // put the distance vector into that provided by the caller
    _dist.swap(_distances);
    return true;
}
    
    // TEMPLATE FUNCTION shortest_path WITH PRED
    // returns false is a negative cycle exists in the network

template<class _NET, class _NETNODEIT, class _NETNODESIZE, 
         class _Pr, class _PRTYPE> inline
bool shortest_path_fifo_labelcorrecting(_NET& _N, _NETNODEIT _S, 
        vector<_NETNODESIZE, allocator<_NETNODESIZE> >& _pred, 
        vector<_PRTYPE, allocator<_PRTYPE> >& _dist,  _Pr& _P)
{
    typedef _PRTYPE distance_type;
    typedef _NETNODESIZE size_type;

    size_type _i, _j;
    _NET::arc_iterator ait;
    distance_type _val;

    // set initial conditions   
    int _n = _N.size_nodes();
    vector<distance_type, allocator<distance_type> > 
        _distances(_n, _Pr::infinity);
    _pred.resize(_n);
    _distances[_S - _N.begin_nodes()] = _Pr::zero;

    // _l is the list of nodes remaining to examine
    list<size_type, allocator<size_type> > _l;
    // _cnt indicates how many times we've looked at a node
    vector<int, allocator<int> > _cnt(_n, 0); 
    // _inList indicates whether a node is currently in the list
    vector<bool, allocator<bool> > _inList(_n, false);

    // put source_node into list
    _l.push_front(_S-_N.begin_nodes());
    _inList[_S-_N.begin_nodes()] = true;

    // while the list is not empty
    while( !_l.empty() )
    {
        // pull node from list to inspect
        _i = _l.front();
        // if we've looked at this node as many times as there
        // are nodes in the network, we're in a negative cycle
        if( ++(_cnt[_i]) >= _n )
            return false;   
        _l.pop_front();
        _inList[_i] = false;

        // for each arc leaving this node
        for(ait=_N.begin_arcs(_i); !(ait==_N.end_arcs(_i)); ait++)
        {
            // if distance from this node to destination is better
            // than destination's current label, then relabel
            _val = _distances[_i] + _P(*ait);
            _j = _N.arcDestinNode(ait);
            if( _val < _distances[_j] )
            {
                // relabel destination node
                _distances[_j] = _val;
                _pred[_j] = _i;
                // insert destin node in list if not already there
                if( !_inList[_j] )
                {
                    _l.push_back(_j);
                    _inList[_j] = true;
                }
            }
        }
    }
    // put outgoing distance vector into parameter provided by caller
    _dist.swap(_distances);
    return true;
}
#endif
