/////////////////////////////////////////////////////////////////////
//
#ifndef __NETWORK__
#define __NETWORK__

#ifndef _LIST_
#include <list>
#endif
#ifndef _VECTOR_
#include <vector>
#endif

// reduce the symbol size for debug builds; MS compilers truncate
// symbols at 255 characters
#ifdef _DEBUG
#define network N_
#define _NODE n_
#define _ARC a_
#define NODELIST NL_
#define ARCLIST AL_
#define _iNode in_
#define _iArc ia_
#endif

#if defined(__BORLANDC__) || (_MSC_VER >= 1100 )
    using namespace std;
#endif

// Microsoft Visual C++ 5.0 (March 19 release) has a problem with
// namespace resolution and default parameters calling default 
// constructors in STL containers; so, we have to define the embedded
// classes _iArc and _iNode outside the network class itself.

#if _MSC_VER == 1100
// HACK FOR VC 5.0
template<class _D, class _s>
struct __Arc
{
    __Arc() {}
    __Arc(const _D arc, _s src, _s dtn) :
        data(arc), source_node(src), destin_node(dtn) {}
    _D data;
    _s source_node;
    _s destin_node;
    bool operator==(const __Arc&) const;
    bool operator!=(const __Arc&) const;
    bool operator< (const __Arc&) const;
    bool operator> (const __Arc&) const;
};


template<class _D, class _ai>
struct __Node   
{
    __Node() {}
    __Node(const _D& n, const _ai& a) :
                data(n), firstArcOut(a) {}
    _D data;
    _ai firstArcOut;
    bool operator==(const __Node& net) const;
    bool operator< (const __Node& net) const;
};
#endif

///template<class _NODE, class _ARC, class _A = allocator<_NODE> >
template<class _NODE, class _ARC, class _A> ///
class network
{
public:
#if _MSC_VER < 1100
    struct _iArc;   
    struct _iNode;  
#endif

    typedef _A allocator_type;
    typedef allocator_type::size_type size_type;
    typedef network<_NODE, _ARC, _A> _Myt;

protected:
    allocator_type _alloc;

    // _iArc
#if _MSC_VER == 1100
    typedef __Arc<_ARC, size_type> _iArc;
#else
    struct _iArc
    {
            _iArc() {}
            _iArc(const _ARC arc, size_type src, size_type dtn) :
                data(arc), source_node(src), destin_node(dtn) {}
            _ARC data;
            size_type source_node;
            size_type destin_node;
            bool operator==(const _iArc& net) const
                { return this==&net; }
            bool operator!=(const _iArc& net) const
                { return this!=&net; }
            bool operator< (const _iArc& net) const
                { return this<&net; }
            bool operator> (const _iArc& net) const
                { return this>&net; }
        };
#endif

/// typedef _A::rebind<_iArc>::other arc_allocator_type
    typedef allocator<_iArc>    arc_allocator_type;     ///

    // ARCLIST
    typedef list< _iArc , arc_allocator_type > ARCLIST;
    typedef ARCLIST::iterator       _arcIt;
    typedef ARCLIST::const_iterator _CarcIt;
    ARCLIST arc_list;

    // _iNode
#if _MSC_VER == 1100
    typedef __Node<_NODE, _arcIt> _iNode;
#else
    struct _iNode   
        {
            _iNode() {}
            _iNode(const _NODE& n, const _arcIt& a) :
                        data(n), firstArcOut(a) {}
            _NODE data;
            _arcIt firstArcOut;
            bool operator==(const _iNode& net) const
                { return this==&net; }
            bool operator< (const _iNode& net) const
                { return this<&net; }
        };
#endif

/// typedef _A::rebind<_iNode>::other node_allocator_type
    typedef allocator<_iNode>   node_allocator_type;    ///


    // NODELIST
    typedef vector<_iNode, node_allocator_type > NODELIST; 
    typedef NODELIST::iterator          _nodeIt;
    typedef NODELIST::const_iterator    _CnodeIt;
    NODELIST node_list;

public:
    typedef allocator_type::value_type          node_value_type;
    typedef allocator_type::reference           node_reference;
    typedef allocator_type::const_reference     const_node_reference;
    typedef allocator_type::pointer             node_pointer;
    typedef allocator_type::const_pointer       const_node_pointer;
    typedef allocator_type::difference_type node_difference_type;

/// typedef _A::rebind<_ARC>::other::value_type         
///     arc_value_type;
/// typedef _A::rebind<_ARC>::other::reference          
///     arc_reference;
/// typedef _A::rebind<_ARC>::other::const_reference    
///     const_arc_reference;
/// typedef _A::rebind<_ARC>::other::pointer            
///     arc_pointer;
/// typedef _A::rebind<_ARC>::other::const_pointer      
///     const_arc_pointer;
/// typedef _A::rebind<_ARC>::other::difference_type    
///     arc_difference_type;
    typedef _ARC                 arc_value_type;        ///
    typedef _ARC&                arc_reference;         ///
    typedef const _ARC&          const_arc_reference;   ///
    typedef _ARC*                arc_pointer;           ///
    typedef const _ARC*          const_arc_pointer;     ///
    typedef node_difference_type arc_difference_type;   ///

        // CLASS node_iterator
    class node_iterator;
    class const_node_iterator;
    friend class node_iterator;
    class node_iterator : 
        public _Bidit<node_value_type, node_difference_type>
    {
        friend class network<_NODE, _ARC, _A>;
        friend class const_node_iterator;
    public:
        node_iterator()
            {}
        node_iterator(_nodeIt _P)
            : _Ptr(_P) {}
        node_reference operator*() const
            { return (*_Ptr).data; }
        node_iterator& operator++()
            { ++_Ptr;
              return (*this); }
        node_iterator operator++(int)
            { node_iterator _Tmp = *this;
              ++*this;
              return (_Tmp); }
        node_iterator& operator--()
            { --_Ptr;
              return (*this); }
        node_iterator operator--(int)
            { node_iterator _Tmp = *this;
              --*this;
              return (_Tmp); }
        bool operator==(const node_iterator& _X) const
            { return (_Ptr == _X._Ptr); }
        node_iterator& operator+=(node_difference_type _N)
            { _Ptr += _N;
              return (*this); }
        node_iterator& operator-=(node_difference_type _N)
            { return (*this += -_N); }
        node_iterator operator+(node_difference_type _N) const
            { node_iterator _Tmp = *this;
              return (_Tmp += _N); }
        node_iterator operator-(node_difference_type _N) const
            { node_iterator _Tmp = *this;
              return (_Tmp -= _N); }
        node_difference_type operator-(const node_iterator& _X) const
            { return _Ptr - _X._Ptr; }
    private:
        _nodeIt _Myit() const
            { return (_Ptr); }
        _nodeIt _Ptr;
    };

        // CLASS const_node_iterator
    friend class const_node_iterator;
    class const_node_iterator : 
        public _Bidit<node_value_type, node_difference_type> 
    {
        friend class network<_NODE, _ARC, _A>;
    public:
        const_node_iterator()
            {}
        const_node_iterator(_CnodeIt _P)
            { _Ptr=_P;}
        const_node_iterator(const node_iterator& _X)
            { _Ptr=_X._Myit(); }
        const_node_reference operator*() const
            { return (*_Ptr).data; }
        const_node_iterator& operator++()
            { ++_Ptr;
              return (*this); }
        const_node_iterator operator++(int)
            { const_node_iterator _Tmp = *this;
              ++*this;
              return (_Tmp); }
        const_node_iterator& operator--()
            { --_Ptr;
              return (*this); }
        const_node_iterator operator--(int)
            { const_node_iterator _Tmp = *this;
              --*this;
              return (_Tmp); }
        bool operator==(const const_node_iterator& _X) const
            { return (_Ptr == _X._Ptr); }
        const_node_iterator& operator+=(node_difference_type _N)
            { _Ptr += _N;
              return (*this); }
        const_node_iterator& operator-=(node_difference_type _N)
            { return (*this += -_N); }
        const_node_iterator operator+(node_difference_type _N) const
            { const_node_iterator _Tmp = *this;
              return (_Tmp += _N); }
        const_node_iterator operator-(node_difference_type _N) const
            { const_node_iterator _Tmp = *this;
              return (_Tmp -= _N); }
        node_difference_type operator-(const const_node_iterator& _X) 
            const { return _Ptr - _X._Ptr; }
    private:
        _CnodeIt _Myit() const
            { return (_Ptr); }
        _CnodeIt _Ptr;
    };

    typedef reverse_bidirectional_iterator<const_node_iterator, 
        node_value_type, const_node_reference, const_node_pointer, 
        node_difference_type>   const_reverse_node_iterator;
    typedef reverse_bidirectional_iterator<node_iterator, 
        node_value_type, node_reference, node_pointer, 
        node_difference_type>   reverse_node_iterator;

    node_iterator begin_nodes() 
        { return node_iterator(node_list.begin()); }
    const_node_iterator begin_nodes() const 
        { return const_node_iterator(node_list.begin()); }

    node_iterator end_nodes() 
        { return node_iterator(node_list.end()); }
    const_node_iterator end_nodes() const 
        { return const_node_iterator(node_list.end()); }

    reverse_node_iterator rbegin_nodes() 
        { return reverse_node_iterator(end_nodes()); }
    const_reverse_node_iterator rbegin_nodes() const 
        { return const_reverse_node_iterator(end_nodes()); }

    reverse_node_iterator rend_nodes() 
        { return reverse_node_iterator(begin_nodes()); }
    const_reverse_node_iterator rend_nodes() const 
        { return const_reverse_node_iterator(begin_nodes()); }

        // CLASS arc_iterator
    class arc_iterator;
    friend class arc_iterator;
    class arc_iterator : 
        public _Bidit<arc_value_type, arc_difference_type>
    {
        friend class network<_NODE, _ARC, _A>;
    public:
        arc_iterator()
            {}
        arc_iterator(_arcIt _P)
            : _Ptr(_P) {}
        arc_reference operator*() const
            { return (*_Ptr).data; }
        arc_iterator& operator++()
            { ++_Ptr;
              return (*this); }
        arc_iterator operator++(int)
            { arc_iterator _Tmp = *this;
              ++*this;
              return (_Tmp); }
        arc_iterator& operator--()
            { --_Ptr;
              return (*this); }
        arc_iterator operator--(int)
            { arc_iterator _Tmp = *this;
              --*this;
              return (_Tmp); }
        bool operator==(const arc_iterator& _X) const
            { return (_Ptr == _X._Ptr); }
    protected:
        _arcIt _Myit() const
            { return (_Ptr); }
        _arcIt _Ptr;
    };

        // CLASS const_arc_iterator
    class const_arc_iterator;
    friend class const_arc_iterator;
    class const_arc_iterator : public arc_iterator 
    {
        friend class network<_NODE, _ARC, _A>;
    public:
        const_arc_iterator()
            {}
        const_arc_iterator(_arcIt _P)
            : arc_iterator(_P) {}
        const_arc_iterator(const arc_iterator& _X)
            : arc_iterator(_X) {}
        const_arc_reference operator*() const
            { return (*_Ptr).data; }
        const_arc_iterator& operator++()
            { ++_Ptr;
              return (*this); }
        const_arc_iterator operator++(int)
            { arc_iterator _Tmp = *this;
              ++*this;
              return (_Tmp); }
        const_arc_iterator& operator--()
            { --_Ptr;
              return (*this); }
        const_arc_iterator operator--(int)
            { arc_iterator _Tmp = *this;
              --*this;
              return (_Tmp); }
        bool operator==(const const_arc_iterator& _X) const
            { return (_Ptr == _X._Ptr); }
    };

    typedef reverse_bidirectional_iterator<const_arc_iterator, 
            arc_value_type, const_arc_reference, const_arc_pointer, 
            arc_difference_type>    const_reverse_arc_iterator;
    typedef reverse_bidirectional_iterator<arc_iterator, 
            arc_value_type, arc_reference, arc_pointer, 
            arc_difference_type>    reverse_arc_iterator;

    arc_iterator begin_arcs() 
        { return arc_iterator(arc_list.begin()); }
    const_arc_iterator begin_arcs() const 
        { return const_arc_iterator(arc_list.begin()); }

    arc_iterator end_arcs() 
        { return arc_iterator(arc_list.end()); }
    const_arc_iterator end_arcs() const 
        { return const_arc_iterator(arc_list.end()); }

    reverse_arc_iterator rbegin_arcs() 
        { return reverse_arc_iterator(end_arcs()); }
    const_reverse_arc_iterator rbegin_arcs() const 
        { return const_reverse_arc_iterator(end_arcs()); }

    reverse_arc_iterator rend_arcs() 
        { return reverse_arc_iterator(begin_arcs()); }
    const_reverse_arc_iterator rend_arcs() const 
        { return const_reverse_arc_iterator(begin_arcs()); }

    arc_iterator begin_arcs(size_type source_node) 
        { return arc_iterator(node_list[source_node].firstArcOut); }
    arc_iterator begin_arcs(node_iterator node) 
        { return arc_iterator((*node._Myit()).firstArcOut); }
    arc_iterator begin_arcs(reverse_node_iterator node) 
        { return 
          arc_iterator((*(++node).base()._Myit()).firstArcOut); }

    const_arc_iterator begin_arcs(size_type source_node) const 
        { return 
          const_arc_iterator(node_list[source_node].firstArcOut); }
    const_arc_iterator begin_arcs(const_node_iterator node) const 
        { return 
          const_arc_iterator((*node._Myit()).firstArcOut); }
    const_arc_iterator begin_arcs(const_reverse_node_iterator node) 
        const { return 
          const_arc_iterator((*(++node).base()._Myit()).firstArcOut);}

    arc_iterator end_arcs(size_type source_node)
        { return arc_iterator(_end_arcs(begin_nodes()+source_node)); }
    arc_iterator end_arcs(node_iterator node)
        { return arc_iterator(_end_arcs(node)); }
    arc_iterator end_arcs(reverse_node_iterator node)
        { return arc_iterator(_end_arcs(node)); }

    const_arc_iterator end_arcs(size_type source_node) const
        { return 
          const_arc_iterator(_end_arcs(begin_nodes()+source_node)); }
    const_arc_iterator end_arcs(const_node_iterator node) const
        { return 
          const_arc_iterator(_end_arcs(node)); }
    const_arc_iterator end_arcs(const_reverse_node_iterator node) 
        const { return 
        const_arc_iterator(_end_arcs(node)); }

protected:
    _arcIt _end_arcs(node_iterator node)
        {
            // it at last node, return end of the arc list
            if( (node==(node_list.end()-1)) || 
                (node==(node_list.end())))
                return arc_list.end();
            // otherwise return first arc of next node
            return (*(++node)._Myit()).firstArcOut;
            }

    _arcIt _end_arcs(reverse_node_iterator node)
        {
            // if at last node, return end of the arc list
            if( (node.base()==(node_list.end()) ))
                return arc_list.end();
            // otherwise, return first arc of next node
            // (reverse iterators point at next element in list)
            return (*node.base()._Myit()).firstArcOut;
        }

    _CarcIt _end_arcs(const_node_iterator node) const
        {
            // it at last node, return end of the arc list
            if( (node==(node_list.end()-1)) || 
                (node==(node_list.end())))
                return arc_list.end();
            // otherwise return first arc of next node
            return (*(++node)._Myit()).firstArcOut;
        }

    _CarcIt _end_arcs(const_reverse_node_iterator node) const
        {
            // if at last node, return end of the arc list
            if( (node.base()==(node_list.end()) ))
                return arc_list.end();
            // otherwise, return first arc of next node
            // (reverse iterators point at next element in list)
            return (*node.base()._Myit()).firstArcOut;
        }

    void _patch_arcs_insert(node_iterator it, size_type n)
        { 
            size_type base = it - begin_nodes();
            // arcs incident to node >= base need to be inc'd by n
            arc_iterator ait(begin_arcs());
            while( !(ait==end_arcs()) )
            {
                if( (*ait._Myit()).source_node >= base )
                    (*ait._Myit()).source_node += n;
                if( (*ait._Myit()).destin_node >= base )
                    (*ait._Myit()).destin_node += n;
                ait++;
            }
        }

public:

    arc_iterator insert_arc(node_iterator source_node,
        node_iterator destin_node, const _ARC& arc = _ARC())
        {
            _iArc netarc(arc, source_node - begin_nodes(), 
                destin_node - begin_nodes());

            _iNode& srcNode = *source_node._Myit();
            _arcIt insertAt(srcNode.firstArcOut);
            _arcIt it(arc_list.insert(insertAt, netarc));
            srcNode.firstArcOut = it;
            // patch previous node's firstArcOut if necessary
            while( !(source_node==begin_nodes()) && 
                ((*(--source_node)._Myit()).firstArcOut==insertAt ))
            {
                (*source_node._Myit()).firstArcOut = it;
            }
            return it;
        }

    arc_iterator insert_arc(arc_iterator arcIt, 
        node_iterator destin_node, const _ARC& arc = _ARC())
        { return 
          insert_arc(begin_nodes()+(*arcIt._Myit()).source_node, 
                destin_node, arc); }

    arc_iterator insert_arc(size_type source_node, 
        size_type destin_node, const _ARC& arc = _ARC())
        { return 
          insert_arc(begin_nodes()+source_node, begin_nodes()+
                destin_node, arc); }

    size_type arcSourceNode(const_arc_iterator arc) const
        { return (*arc._Myit()).source_node; }
    size_type arcDestinNode(const_arc_iterator arc) const
        { return (*arc._Myit()).destin_node; }

    void clear()
        { node_list.clear();
          arc_list.clear(); }
    void clear_arcs()
        { erase_arcs(begin_arcs(), end_arcs()); }

    node_iterator erase_nodes(size_type sfirst, size_type slast)
        {
            slast++;
            size_type nodecount = slast - sfirst;
            if( nodecount < 1 ) 
                return begin_nodes() + sfirst;
            size_type ssrc, sdtn;
            arc_iterator ai(begin_arcs());
            while( !(ai == end_arcs() ) )
            {
                // delete arcs incident to any of the dying nodes
                ssrc = (*ai._Myit()).source_node;
                sdtn = (*ai._Myit()).destin_node;
                if( (sfirst <= ssrc && ssrc < slast) ||
                    (sfirst <= sdtn && sdtn < slast) )
                    erase_arcs(ai++);
                else
                {
                    // update arcs incident to any higher-numbd nodes
                    if( ssrc >= slast )
                        (*ai._Myit()).source_node = ssrc - nodecount;
                    if( sdtn >= slast )
                        (*ai._Myit()).destin_node = sdtn - nodecount;
                    ai++;
                }
            }
            return node_iterator(
                node_list.erase((begin_nodes()+sfirst)._Myit(), 
                (begin_nodes()+slast)._Myit())); 
        }
    node_iterator erase_nodes(node_iterator first, node_iterator last)
        { return erase_nodes(first-begin_nodes(), last-begin_nodes()); }

    node_iterator erase_nodes(size_type s)
        {
            arc_iterator ai(begin_arcs());
            while( !(ai==end_arcs() ) )
            {
                // delete arcs incident to this node
                if( s == (*ai._Myit()).source_node ||
                    s == (*ai._Myit()).destin_node )
                    erase_arcs(ai++);
                else
                {
                    // update arcs incident to higher-numbered nodes
                    if( (*ai._Myit()).source_node > s )
                        (*ai._Myit()).source_node -= 1;
                    if( (*ai._Myit()).destin_node > s )
                        (*ai._Myit()).destin_node -= 1;
                    ai++;
                }
            }
            // delete the nodes themselves
            return node_iterator(
                node_list.erase((begin_nodes()+s)._Myit())); 
        }
    node_iterator erase_nodes(node_iterator it)
        { return erase_nodes(it - begin_nodes()); }

    arc_iterator erase_arcs(arc_iterator first, arc_iterator last)
        {
            // go through and remove mates...
            // find out the source node of the first and last arcs
            size_type source = (*first._Myit()).source_node;
            size_type destin = (*(--last)._Myit()).source_node;
            last++;

            // if our first arc is not the source node's first arc, 
            // we don't want to update it, otherwise determine how
            // many to update
            source++;
            while( (source != 0) && 
                   (first==node_list[source-1].firstArcOut) )
                source--;

            // then kill 'em; ait will point to first arc left
            arc_iterator ait;
            ait = arc_list.erase(first._Myit(), last._Myit());
            // now go through and update the nodes
            for(size_type i=source;i<=destin;i++)
                node_list[i].firstArcOut = ait._Myit();
            return ait;
        }
    arc_iterator erase_arcs(arc_iterator it)
        { arc_iterator ait(it);
          return erase_arcs(ait, ++it); }

    bool empty() const
        { return node_list.empty(); }
    bool empty_arcs() const
        { return arc_list.empty(); }

    void reserve_nodes(size_type n)
        { node_list.reserve(n); }

    size_type size_nodes() const
        { return node_list.size(); }
    size_type size_arcs() const
        { return arc_list.size(); }

    size_type capacity_nodes() const
        { return node_list.capacity(); }
    size_type capacity_arcs() const
        { return arc_list.max_size(); }

    void resize_nodes(size_type _N, _NODE _X = _NODE())
        { if( size_nodes() < _N )
            insert_nodes(end_nodes(), _N - size_nodes(), _X);
          else if (_N < size_nodes())
            erase_nodes(begin_nodes()+_N, end_nodes()); }

    node_iterator insert_nodes(node_iterator it, 
        const _NODE& x = _NODE())
        { _iNode node(x, _end_arcs(it));
          _patch_arcs_insert(it, 1);
          return node_iterator(node_list.insert(it._Myit(), node)); }
    void insert_nodes(node_iterator it, size_type n, 
        const _NODE& x = _NODE())
        { _iNode node(x, _end_arcs(it)); 
          _patch_arcs_insert(it, n); 
          node_list.insert(it._Myit(), n, node); }

    const_node_reference node(size_type pos) const
        { return node_list.at(pos).data; }
    node_reference node(size_type pos)
        { return node_list.at(pos).data; }

    node_reference front_nodes()
        { return (*begin_nodes()); }
    const_node_reference front_nodes() const
        { return (*begin_nodes()); }
    node_reference back_nodes()
        { return (*(end_nodes() - 1)); }
    const_node_reference back_nodes() const
        { return (*(end_nodes() - 1)); }
    void push_back_nodes(const _NODE& _X)
        { insert_nodes(end_nodes(), _X); }
    void pop_back_nodes()
        { erase_nodes(end_nodes() - 1); }
    size_type max_size_nodes() const
        { return node_list.max_size(); }
public:
    network() {}
    ~network() {}
};

#endif  // !__NETWORK__
