/* formtest.cgi.c */

char id[] = "Copyright (c) 1997 by Bob Kamins";

/* This is an example of how to send e-mail from a CGI program */

/* Object file permissions should be setuid (rws--s--x) */
/* so that the log and errorlog files can be -rw------- */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>

#define LOGFILE "formtest.log"   /* name of program log file */
#define ERRORLOG "formtest.err"  /* name of error log file */
#define NAMESIZE 32              /* maximum variable name size */
#define VALUESIZE 256            /* maximum value entry size */
#define MAIL "/usr/lib/sendmail" /* path of sendmail program */
#define MAILOPT ""               /* any options to sendmail */
#define MAILTO "bob@kamins.com"  /* product expeditor */

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

/* function prototypes */

void checkInputHdr (void);
int sendReply (void);
void err (const char *format, ...);
void getNameValuePairs (void);
int getPair (char *name, char *value);
int getWord (char *word, int del, int max);
int bin (int hex);
void saveValue (const char *name, const char *value);
void sendMail (void);
void child (int *pfd);
void parent (int *pfd);

/* global variables */

char *Name = NULL;
char *Prod = NULL;
char *Rush = NULL;

/*-------------------------------------------*
 * CGI program processes orders from the Web *
 *-------------------------------------------*/

int main() {
    checkInputHdr();
    getNameValuePairs();
    if (sendReply() && Rush != NULL) {
        sendMail();
    }
    return 0;
}

/*--------------------------------------------------------------*
 * This step is just a formality, since the server will always  *
 * get this stuff right. I guess someone might try to use this  *
 * program for something else (?) in which case it will bomb.   *
 * Anyway, we have to read it to get into position for reading  *
 * the name/value pairs.                                        *
 *--------------------------------------------------------------*/

void checkInputHdr (void) {
    char *cmp;

    cmp = getenv ("REQUEST_METHOD");
    if (cmp == NULL)
        err ("Missing REQUEST_METHOD");
    if (strcmp (cmp, "POST") != 0)
        err ("REQUEST_METHOD not POST");
    cmp = getenv ("CONTENT_TYPE");
    if (cmp == NULL)
        err ("Missing CONTENT_TYPE");
    if (strcmp (cmp, "application/x-www-form-urlencoded") != 0)
        err ("Not form results");
}

/*-----------------------------------------------------------*
 * Read the NAME/VALUE pairs from the form and put them into *
 * into a linked list for later.                             *
 *-----------------------------------------------------------*/

void getNameValuePairs (void) {
    char name [NAMESIZE + 1];
    char value [VALUESIZE + 1];
    int length;
    int ch;
    FILE *log;
    time_t t;

    /* open log file -- save time of day.  This file should */
    /* be in the same directory as the html page containing */
    /* the form and writable by owner.                      */

    log = fopen (LOGFILE, "at");
    if (log == NULL)
        err ("Can't open " LOGFILE);
    time (&t);
    (void) fprintf (log, "-> %s", asctime (localtime (&t)));

    /* get content length then read that much from stdin */

    length = atoi (getenv ("CONTENT_LENGTH"));
    while (length > 0) {
        length -= getWord (name, '=', NAMESIZE);
        length -= getWord (value, '&', VALUESIZE);
        saveValue (name, value);
        (void) fprintf (log, "%s=%s\n", name, value);
    }

    if (fclose (log) == -1)
        err ("Can't close " LOGFILE);
}

/*--------------------------------------------------------------*
 * getWord() gets up to max bytes from standard input delimited *
 * by del, to make a word.  It also decodes hex escapes and '+' *
 * characters (spaces).  The number of characters read is kept  *
 * in ctr and returned to the caller for bookkeeping purposes.  *
 *--------------------------------------------------------------*/

int getWord (char *word, int del, int max) {
    int ctr = 0;
    int ch;

    while ((ch = getchar()) != EOF && ch != del) {
        switch (ch) {
        case '%':                        /* hex character */
            ch = bin (getchar()) * 16;
            ctr++;
            max--;
            ch += bin (getchar());
            ctr++;
            max--;
            break;
        case '+':                        /* space character */
            ch = ' ';
            break;
        default:                         /* normal character */
            break;
        }

        /* if still room in the output, add this character */

        if (max > 0) {
            *word++ = ch;
            max--;
        }
        ctr++;
    }
    *word = '\0';
    ctr++;

    return ctr;
}

/*--------------------------------------------------------*
 * Converts one ASCII hex digit to its binary equivalent. *
 *--------------------------------------------------------*/

int bin (int hexdigit) {
    int b;

    b = hexdigit - '0';
    if (b > 9) {
        b -= 7;
    }

    return b;
}

/*----------------------------------------------------------*
 * Get dynamic memory to store the value, then associate it *
 * with the appropriate variable.                           *
 *----------------------------------------------------------*/

void saveValue (const char *name, const char *value) {
    char *cp;

    if ((cp = (char *) malloc (strlen (value) + 1)) == NULL)
        err ("Out of memory");
    strcpy (cp, value);
    if (strcmp (name, "name") == 0)
        Name = cp;
    else if (strcmp (name, "prod") == 0)
        Prod = cp;
    else if (strcmp (name, "rush") == 0)
        Rush = cp;
}

/*--------------------------------------------------------------*
 * Send the top part of the reply page, then check a few things *
 * and issue a message if an error occurs or acknowledgement if *
 * not.  Send the rest of the page and return the error code.   *
 *--------------------------------------------------------------*/

int sendReply (void) {
    int ok = FALSE;                   /* error code */

    /* send the first part of the page */

    (void) printf ("Content-type: text/html\n\n");
    (void) printf ("<html>\n");
    (void) printf ("<head>\n");
    (void) printf ("<title>\n");
    (void) printf ("CGI send mail test\n");
    (void) printf ("</title>\n");
    (void) printf ("</head>\n");
    (void) printf ("<body>\n");
    (void) printf ("<center>\n");
    (void) printf ("<br>\n");
    (void) printf ("<br>\n");
    (void) printf ("<br>\n");
    (void) printf ("<br>\n");

    /* do a simple validation */

    if (Name == NULL || strcmp (Name, "") == 0) {
        (void) printf ("<h1> Your name is required </h1>");
    } else if (Prod == NULL || strcmp (Prod, "") == 0) {
        (void) printf ("<h1> You must select an item </h1>");
    } else {
        ok = TRUE;
    }

    /* send error message or acknowledgement */

    if (ok) {
        (void) printf ("<h1> Thanks </h1>\n");
        (void) printf ("<h1> We appreciate your order </h1>\n");
        if (Rush) {
            (void) printf ("<h1> It will be shipped immediately </h1>\n");
        }
    } else {
        (void) printf ("<h1> Please resubmit your form </h1>");
    }

    /* send the message trailer */

    (void) printf ("</center>\n");
    (void) printf ("</body>\n");
    (void) printf ("</html>\n");

    return ok;
}

/*------------------------------------------------------------*
 * Flush standard output, so the user sees all of the HTML.   *
 * Create a pipe, then fork a child to exec sendmail. Parent  *
 * writes to the pipe as standard output and child reads from *
 * the pipe as standard input.                                *
 *------------------------------------------------------------*/

void sendMail (void) {
    int pfd [2];

    if (fflush (stdout) == EOF)
        err ("Can't flush stdout");
    if (pipe (pfd) == -1)
        err ("Can't open pipe");
    switch (fork()) {
    case 0:              /* must be the child */
        child (pfd);
        break;
    default:             /* must be the parent */
        parent (pfd);
        break;
    }
}

/*--------------------------------------------------------------*
 * Child process closes unused writing end of pipe, closes its  *
 * own standard input and dup's the reading end of the pipe, so *
 * it becomes the child's standard input.  It then closes the   *
 * reading end of the pipe and exec's sendmail, which ends up   *
 * reading from the pipe (which by now is connected to its      *
 * parent's standard output.                                    *
 *--------------------------------------------------------------*/

void child (int *pfd) {
    if (close (pfd [1]) == -1)
        err ("Child can't close pfd [1]");
    if (close (0) == -1)
        err ("Child can't close stdin");
    if (dup (pfd [0]) != 0)
        err ("Child can't dup stdin");
    if (close (pfd [0]) == -1)
        err ("Child can't close pfd [0]");
    execl (MAIL, MAILOPT, MAILTO, (char *)0);
    err ("exec failed");
}

/*--------------------------------------------------------------*
 * The parent closes unused reading end of pipe, closes its own *
 * standard output and dup's the writing end of the pipe, so it *
 * becomes stdout.  After closing the (now unused) writing end  *
 * of the pipe, it sends its mail text to standard output.  The *
 * other end of the pipe is the child's standard input.         *
 *--------------------------------------------------------------*/

void parent (int *pfd) {

    /* make the pipe into stdout */

    if (close (pfd [0]) == -1)
        err ("Parent can't close pfd [0]");
    if (close (1) == -1)
        err ("Parent can't close stdout");
    if (dup (pfd [1]) != 1)
        err ("Parent can't dup stdout");
    if (close (pfd [1]) == -1)
        err ("Parent can't close pfd [1]");

    /* send the message */

    (void) printf ("To: Expediter\n");
    (void) printf ("From: Web_Server\n");
    (void) printf ("Subject: Rush Order\n");
    (void) printf ("\n");
    (void) printf ("Please process the following "
                   "order immediately:\n\n");
    (void) printf ("Name: %s\n", Name);
    (void) printf ("Product: %s\n", Prod);
    (void) printf ("\n");
}

/*-------------------------------------------------------------*
 * Log message to file and terminate with non-zero error code. *
 *-------------------------------------------------------------*/

void err (const char *format, ...) {
    FILE *errfile;
    va_list ap;

    errfile = fopen (ERRORLOG, "wt");
    if (errfile != NULL) {
        va_start (ap, format);
        (void) vfprintf (errfile, format, ap);
        (void) fprintf (errfile, "\n");
        va_end (ap);
    }

    exit (EXIT_FAILURE);
}
