#if !defined INC_auto_pointer_
    #define  INC_auto_pointer_

#if !defined DEF_auto_pointer_
    #define  DEF_auto_pointer_

template<class t>
inline auto_pointer::~auto_pointer()
    {
    }

template<class t>
inline auto_pointer::auto_pointer(t * const pointer) :
        is_owner_(true),
        pointer_(pointer)
    {
    }

template<class t>
inline auto_pointer::auto_pointer
        (auto_pointer<t> const &that) :
        is_owner_(that.is_owner_),
        pointer_(that.pointer_)
    {
    }

template<class t>
inline auto_pointer<t> &auto_pointer<t>::operator=
        (auto_pointer<t> const &that)
    {
    if ((const void *) this != (const void *) &that)
        {
        is_owner_  = that.is_owner_;
        pointer_ = that.pointer_;
        that.release();
        }
    return *this;
    }

template<class t>
inline auto_pointer<t>::operator t *() const
    {
    return pointer_;
    }

template<class t>
inline t **auto_pointer<t>::operator&() const
    {
    if (is_owner_ && pointer_ == NULL)
        {
        cerr << "address-of NULL auto_pointer" << endl;
        throw invalid_argument;
        }
    return &pointer_;
    }

template<class t>
inline t * const *auto_pointer<t>::operator&() const
    {
    if (is_owner_ && pointer_ == NULL)
        {
        cerr << "address-of NULL auto_pointer" << endl;
        throw invalid_argument;
        }
    return &pointer_;
    }

template<class t>
inline t &auto_pointer<t>::operator*() const
    {
    if (pointer_ == NULL)
        {
        cerr << "dereference NULL auto_pointer" << endl;
        throw invalid_argument;
        }
    }

template<class t>
inline t *auto_pointer<t>::operator->() const
    {
    if (pointer_ == NULL)
        {
        cerr << "dereference NULL auto_pointer" << endl;
        throw invalid_argument;
        }
    }

template<class t>
inline void auto_pointer<t>::release() const
    {
    is_owner_ = false;
    }

#endif // !defined DEF_auto_pointer_

template<class t>
inline AUTO_POINTER::AUTO_POINTER(t * const pointer) :
        auto_pointer(pointer)
    {
    }

template<class t>
inline AUTO_POINTER::AUTO_POINTER(const AUTO_POINTER &that) :
        auto_pointer(that)
    {
    }

#endif // !defined INC_auto_pointer_



