#include <stdlib.h>
#include <string.h>
#include "Globals.h"
#include "File.h"


void strdelete(char *s, int pos, int len)
{
	int slen;

   if (--pos < 0)
      return;
   slen = strlen(s) - pos;
   if (slen <= 0)
      return;
   s += pos;
   if (slen <= len) {
      *s = 0;
      return;
   }
   while ((*s = s[len])) 
		s++;
}


File::File()
: m_file(0)
{
}

File::~File()
{
	if (m_file) {
		m_file->close();
		delete m_file;
	}
}

void File::Init(char* FileName)
{
	m_file = new ifstream;
	m_file->open(FileName, ios::in);
//	int num = m.size();
}

#ifdef _USEMAP
BOOL File::GetRecord(sVariantRecord& record) 
{
	char prefix, lpszTokenLine[81];
	short recordFormat;
	float number;
	char* here;
	short datatype;
	CKey key;

	// priming read
	m_file->getline(lpszTokenLine, 81);
	if (m_file->eof()) {
		return FALSE;
	}
	prefix = lpszTokenLine[0];
	strdelete(lpszTokenLine, 1, 1);

	while (prefix != '^') {
		switch (prefix) {
		case 'N':
			strcpy(record.Name, lpszTokenLine);
			break;
		case 'F':
			recordFormat = atoi(lpszTokenLine);
			record.Format = recordFormat;
			break;
		default:
			key.m_format = recordFormat;
			key.m_prefix = prefix;
			j = m.find(key);
			if (j != m.end()) {
				datatype = (*j).second.m_datatype;
				switch (datatype) {
				case FLOAT:
					here = (char*)&record + (*j).second.m_offset;
					number = atof(lpszTokenLine);
					memcpy(here, &number, sizeof(float));
					break;
				case STRING:
					here = (char*)&record + (*j).second.m_offset;
					strcpy(here, lpszTokenLine);
					break;
				default:
					// some error
					break;
				}	// switch
			}
			break;
		}	// switch
		m_file->getline(lpszTokenLine, 81);
		prefix = lpszTokenLine[0];
		strdelete(lpszTokenLine, 1, 1);
	}
	return TRUE;
}

#else

BOOL File::GetRecord(sVariantRecord& record) 
{
	char prefix, lpszTokenLine[81];
	int recordFormat;

	// priming read
	m_file->getline(lpszTokenLine, 81);
	if (m_file->eof()) {
		return FALSE;
	}
	prefix = lpszTokenLine[0];
	strdelete(lpszTokenLine, 1, 1);

	while (prefix != '^') {
		switch (prefix) {
		case 'N':
			strcpy(record.Name, lpszTokenLine);
			break;
		case 'F':
			recordFormat = atoi(lpszTokenLine);
			record.Format = recordFormat;
			break;
		default:
			switch (recordFormat) {
			case FORMAT1:
				switch (prefix) {
				case '$':
					record.sFormat1.Amount = atof(lpszTokenLine);
					break;
				case 'D':
					strcpy(record.sFormat1.Date, lpszTokenLine);
					break;
				}
				break;
			case FORMAT2:
				switch (prefix) {
				case 'D':
					strcpy(record.sFormat2.Date, lpszTokenLine);
					break;
				case 'T':
					strcpy(record.sFormat2.Desc, lpszTokenLine);
					break;
				}
				break;
			case FORMAT3:
				switch (prefix) {
				case '$':
					record.sFormat3.Amount = atof(lpszTokenLine);
					break;
				case 'D':
					strcpy(record.sFormat3.Date, lpszTokenLine);
					break;
				case 'T':
					strcpy(record.sFormat3.Desc, lpszTokenLine);
					break;
				}
				break;
			}
		}
		m_file->getline(lpszTokenLine, 81);
		prefix = lpszTokenLine[0];
		strdelete(lpszTokenLine, 1, 1);
	}
	return TRUE;
}

#endif	// #ifdef _USEMAP
 

