// MODAL0, ctor/dtor and big lines before running
//////////////////////////////////////////////////////
#include "MODALDLG.HPP"
#include "KW.HPP"
#include "CONTROLS.HPP"

MODALDLG::MODALDLG(
	SHOWDATA* Guru, HWND hWndParent, HINSTANCE hInst,
	const char szDescrFile[], const char szDescript[],
	const char szResourceType[])
	: _guru(Guru), _hP(hWndParent), _hI(hInst),
	_input(hInst, szDescrFile, szResourceType),
	_dsect(szDescript)
{
DESCRIPT Line;
STR Type;
_valid = SHOWDATA::DESCNOTFOUND;
_pGXY = 0;
_hDlg = 0;
_hThinFont = 0;
_nCtls = _xOffset = 0;
for(int i = 0; i< CTABSIZE; i++){
	_ctab[i].group = 0;
	_ctab[i].ctl = 0;
	}
for(_input.reset(); _input.get(Line); ){
	Line.type(Type);
	if(Type != KW::DIALOG)
		continue;
	STR Var;
	Line.value(KW::VAR, Var);
	if(Var != _dsect)
		continue;
	_valid = SHOWDATA::OK;
	break;
	}
if(SHOWDATA::OK !=_valid)
	return;
_dlgline = Line;
if(!_initGeometry())
	return;

// 0 unsed, then IDOK, IDCANCEL and tabs:
_xOffset = 3 + _ng;

for(_nCtls = 0; _input.get(Line); ){
	Line.type(Type);
	if(Type == KW::ENDDIALOG)
		break;
	int added = _addCtlToDlg(Line, _xOffset + _nCtls);
	_nCtls += added;
	}
_putTabsAndOKCAN();
}

MODALDLG::~MODALDLG()
{
if(_pGXY != 0){
	delete [] _pGXY;
	_pGXY = 0;
	}
if(_hThinFont != 0){
	DeleteObject((HGDIOBJ)_hThinFont);
	_hThinFont = 0;
	}
for(int i = _xOffset; i < _xOffset + _nCtls; i++){
	CTL *p = _ctab[i].ctl;
	if(0 == p)
		continue;
	delete _ctab[i].ctl;
	_ctab[i].ctl = 0;
	for(int j = i+1; j < _xOffset + _nCtls; j++)
		if(p == _ctab[j].ctl)
			_ctab[j].ctl = 0;
	}
}

int MODALDLG::_addCtlToDlg(
					const DESCRIPT& Desc, int xCtl)
{
int added;

CTL *pCTL = virtualCTLCtor(Desc);
if(0 == pCTL)
	return 0;
int nGroup = Desc.value(KW::GROUP);
if(!_ng){
	nGroup = 0;
	}
else{
	if(nGroup >= _ng)
		nGroup = _ng-1;
	if(nGroup < 0)
		nGroup = 0;
	}
added = pCTL->addToDlg(xCtl, &_template,
		_pGXY[nGroup].duxNext,
		_pGXY[nGroup].duyNext);
_addToGroupGeometry(nGroup, pCTL->duW(), pCTL->duH());
for(int i = 0; i < added; i++){
	_ctab[xCtl+i].group = nGroup;
	_ctab[xCtl+i].ctl = pCTL;
	}
return added;
}

CTL* MODALDLG::virtualCTLCtor(const DESCRIPT& Desc)
{
STR Type;
Desc.type(Type);
if(Type == KW::EDIT)
	return new CTLEDIT(Desc, _guru, this);
if(Type == KW::CHECK)
	return new CTLCHECK(Desc, _guru, this);
if(Type == KW::RADIO)
	return new CTLRADIO(Desc, _guru, this);
//...
return 0;
}
