Listing 2

#include <windows.h>

static char *msg_title = "EntryPoint";

// First DLL function
long MessA(HWND hWnd, int num, LPSTR name)
{
  char buf[80];
  wsprintf(buf, "MessA: num = %d, name = %s", num, name);
  MessageBox(hWnd, buf, msg_title, MB_OK);
  return('A');
}

// Second DLL function
int MessB(HWND hWnd, LPSTR name, char ch, long blah)
{
  char buf[80];
  wsprintf(buf, "MessB: name = %s, ch = %c, blah = %lx",
           name, ch, blah);
  MessageBox(hWnd, buf, msg_title, MB_OK);
  return('B');
}

// Third DLL function
int MessC(HWND hWnd, char ch)
{
  char buf[80];
  wsprintf(buf, "MessC: ch = %c", ch);
  MessageBox(hWnd, buf, msg_title, MB_OK);
  return('C');
}

// Fourth DLL function
LPSTR MessD(HWND hWnd, LPSTR str)
{
  char buf[80];
  wsprintf(buf, "MessD: str = %s", str);
  MessageBox(hWnd, buf, msg_title, MB_OK);
  return(str);
}

#define BUILD_FUNCTION_ARRAY
#include "testenum.h"        // Defines fxn pointer array

// Must be extern "C" so name isn't mangled
extern "C" {

// Entry Point Function
void FAR _export Entry(void)
{
  // The following variables must be static
  // They CANNOT be on the stack, nor can any
  // automatic variables be defined.
  static short hold_ds;
  static short hold_bp;      // bp may not be needed
  static short hold_ip;      // depending on optimizations
  static short hold_cs;
  static short func_id;

  // Pop everything down to the
  // DLL function's argument list
  asm {
    pop hold_ds;
    pop hold_bp;
    pop hold_ip;
    pop hold_cs;
    pop func_id;
  }

  // Call the DLL function
  (pFunc[func_id])();

  // Restore the stack so the entry point
  // function can return correctly
  asm {
    push func_id;
    push hold_cs;
    push hold_ip;
    push hold_bp;
    push hold_ds;
  }
}

}  // extern "C"


// The LibMain and WEP functions that follow are necessary
//  to initalize and shutdown the DLL.
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg,
                       WORD cbHeapSize, LPSTR lpszCmdLine)
{
  return LocalInit(wDataSeg, NULL, cbHeapSize);
}

int FAR PASCAL WEP(int nParameter)
{
  return TRUE;
}
