Listing 1

#ifndef __TESTENUM_H
#define __TESTENUM_H

#ifdef BUILD_FUNCTION_ARRAY // defined in DLL code    

  // Pointer to function taking / returning void
  typedef void (*PFVV)();

  // DECL_FUNC casts DLL fxn to a PFVV, to be
  // added to the function pointer array
  #define DECL_FUNC(x) (PFVV)x

  // Define a function pointer array (done in dll)
  PFVV pFunc[] = {

#else

  // DECL_FUNC prepends iFunc_ to the DLL fxn
  // name, to be added to the fxn id enum
  #define DECL_FUNC(x) iFunc_##x

  // Define a function id enum (done in application)
  enum FuncNumber {

#endif
  // Add all the functions to the list being built
  DECL_FUNC(MessA),
  DECL_FUNC(MessB),
  DECL_FUNC(MessC),
  DECL_FUNC(MessD)
};

#ifndef BUILD_FUNCTION_ARRAY
  // Define the entry point fxn pointer (in app)
  long (FAR *Entry)(enum FuncNumber, ...);
#endif

#endif  // #ifndef __TESTENUM_H
