///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#include <kfThread.h>
#include <kfReferenceCount.h>
#include "kfRunnable.h"

class CKFMTThreadImplementation : public CKFReferenceCount {
  public:
    HANDLE            m_thread;
    unsigned long     m_thread_id;
    CKFMT::CRunnable*  m_runnable;
    CKFMT::CThread*    m_thread_object;

    CKFMTThreadImplementation() {}

    static LONG start_thread(CKFMTThreadImplementation* a_th)
    {
        a_th->m_runnable->run();
        a_th->m_runnable->m_impl->completed();
 	delete a_th->m_thread_object;
        return 0;
    }
    
    CKFMTThreadImplementation(CKFMT::CThread* a_th, CKFMT::CRunnable* a_run ,
                                                int stack_size)
    {
        m_runnable = a_run ;
        m_thread = CreateThread(
            NULL, // default security
            stack_size,
            (LPTHREAD_START_ROUTINE)CKFMTThreadImplementation::start_thread,
            (LPVOID)this,
            CREATE_SUSPENDED,
            &m_thread_id);
        assert(m_thread != NULL); // XXX PK 
	m_thread_object = a_th;
    }

  private:
    ~CKFMTThreadImplementation()
    {
        if (m_thread_id != GetCurrentThreadId()) {
            CloseHandle(m_thread);
        }
    }
};

//--------------------------------------------------------

CKFMT::CThread::CThread(CKFMT::CRunnable* a_run, int stack_size)
{
    m_impl = new CKFMTThreadImplementation(this, a_run, stack_size);   
}

//--------------------------------------------------------

CKFMT::CThread::CThread(const CThread& a_m)
{
    m_impl = a_m.m_impl;
    m_impl->increment();
}

//--------------------------------------------------------

CKFMT::CThread& 
CKFMT::CThread::operator= (const CKFMT::CThread& a_m)
{ 
    m_impl->decrement();
    m_impl = a_m.m_impl;
    m_impl->increment();

    return *this;
}

//--------------------------------------------------------

CKFMT::CThread::~CThread()
{
    m_impl->decrement();
}

//--------------------------------------------------------

void
CKFMT::CThread::make_runnable()
{
    DWORD ret = ResumeThread(m_impl->m_thread);
    assert(ret == 1);
}

//--------------------------------------------------------

unsigned long
CKFMT::CThread::get_thread_id()
{
    return m_impl->m_thread_id;
}

//--------------------------------------------------------

void
CKFMT::CThread::exit(int code)
{
    assert(m_impl->m_thread_id != GetCurrentThreadId());
    TerminateThread(m_impl->m_thread, code);
    m_impl->m_runnable->decrement();
    delete this;
}

//--------------------------------------------------------

unsigned long
CKFMT::CThread::current_id()
{
    return GetCurrentThreadId();
}

//--------------------------------------------------------

void
CKFMT::CThread::current_exit(int code)
{
    ExitThread(code);
}

