///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#include <kfReferenceCount.h>
#include <kfThread.h>
#include <assert.h>
#include "kfMutexWin32.h"

//--------------------------------------------------------

CKFMT::CMutex::CMutex(const char* a_name)
{
    m_impl = new CKFMTMutexImplementation(a_name);   
}

//--------------------------------------------------------

CKFMT::CMutex::CMutex(const CMutex& a_m)
{
    m_impl = a_m.m_impl;
    m_impl->increment();
}

//--------------------------------------------------------

CKFMT::CMutex& 
CKFMT::CMutex::operator= (const CKFMT::CMutex& a_m)
{ 
    m_impl->decrement();
    m_impl = a_m.m_impl;
    m_impl->increment();

    return *this;
}

//--------------------------------------------------------

CKFMT::CMutex::~CMutex()
{
    m_impl->decrement();
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CMutex::lock()
{
    DWORD ret = WaitForSingleObject(m_impl->m_mutex, INFINITE);
    if (ret == WAIT_FAILED) {
        return Error;
    } 
  
    m_impl->m_last_owner = GetCurrentThreadId();
    return Ok;
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CMutex::try_lock()
{
    DWORD ret = WaitForSingleObject(m_impl->m_mutex, 1);
    if (ret == WAIT_FAILED) {
        return Error;
    } else if (ret == WAIT_TIMEOUT) {
        return AlreadyLocked;
    }
    
    m_impl->m_last_owner = GetCurrentThreadId();
    return Ok;
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CMutex::unlock()
{
    m_impl->m_last_owner = -1;
    if (ReleaseMutex(m_impl->m_mutex) == FALSE) {
        return Error;
    }
    return Ok;
}

CKFBool
CKFMT::CMutex::am_owner()
{
    return (CKFBool)(m_impl->m_last_owner == GetCurrentThreadId());
}
